/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractNarMojo;
import com.github.maven_nar.Library;
import com.github.maven_nar.NarProperties;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractResourcesMojo
extends AbstractNarMojo {
    @Parameter(defaultValue="bin", required=true)
    private String resourceBinDir;
    @Parameter(defaultValue="include", required=true)
    private String resourceIncludeDir;
    @Parameter(defaultValue="lib", required=true)
    private String resourceLibDir;
    @Component(role=ArchiverManager.class)
    private ArchiverManager archiverManager;

    protected final int copyBinaries(File srcDir, String aol) throws IOException, MojoExecutionException, MojoFailureException {
        int copied = 0;
        File binDir = new File(srcDir, this.resourceBinDir);
        if (binDir.exists()) {
            File binDstDir = this.getLayout().getBinDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), aol);
            this.getLog().debug((CharSequence)("Copying binaries from " + binDir + " to " + binDstDir));
            copied += NarUtil.copyDirectoryStructure(binDir, binDstDir, null, "**/*~,**/#*#,**/.#*,**/%*%,**/._*,**/CVS,**/CVS/**,**/.cvsignore,**/SCCS,**/SCCS/**,**/vssver.scc,**/.svn,**/.svn/**,**/.DS_Store");
        }
        return copied;
    }

    protected final int copyIncludes(File srcDir) throws IOException, MojoExecutionException, MojoFailureException {
        int copied = 0;
        File includeDir = new File(srcDir, this.resourceIncludeDir);
        if (includeDir.exists()) {
            File includeDstDir = this.getLayout().getIncludeDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion());
            this.getLog().debug((CharSequence)("Copying includes from " + includeDir + " to " + includeDstDir));
            copied += NarUtil.copyDirectoryStructure(includeDir, includeDstDir, null, "**/*~,**/#*#,**/.#*,**/%*%,**/._*,**/CVS,**/CVS/**,**/.cvsignore,**/SCCS,**/SCCS/**,**/vssver.scc,**/.svn,**/.svn/**,**/.DS_Store");
        }
        return copied;
    }

    protected final int copyLibraries(File srcDir, String aol) throws MojoFailureException, IOException, MojoExecutionException {
        int copied = 0;
        File libDir = new File(srcDir, this.resourceLibDir);
        if (libDir.exists()) {
            if (this.getLibraries().isEmpty()) {
                this.getLog().warn((CharSequence)"Appear to have library resources, but not Libraries are defined");
            }
            for (Library element : this.getLibraries()) {
                Library library = element;
                String type = library.getType();
                File typedLibDir = new File(libDir, type);
                if (typedLibDir.exists()) {
                    libDir = typedLibDir;
                }
                File libDstDir = this.getLayout().getLibDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), aol, type);
                this.getLog().debug((CharSequence)("Copying libraries from " + libDir + " to " + libDstDir));
                String includes = "**/*." + NarProperties.getInstance(this.getMavenProject()).getProperty(NarUtil.getAOLKey(aol) + "." + type + ".extension");
                if (new AOL(aol).getOS().equals("Windows") && type.equals("shared")) {
                    includes = includes + ",**/*.lib";
                }
                copied += NarUtil.copyDirectoryStructure(libDir, libDstDir, includes, "**/*~,**/#*#,**/.#*,**/%*%,**/._*,**/CVS,**/CVS/**,**/.cvsignore,**/SCCS,**/SCCS/**,**/vssver.scc,**/.svn,**/.svn/**,**/.DS_Store");
            }
        }
        return copied;
    }

    protected final void copyResources(File srcDir, String aol) throws MojoExecutionException, MojoFailureException {
        int copied = 0;
        try {
            copied += this.copyIncludes(srcDir);
            copied += this.copyBinaries(srcDir, aol);
            copied += this.copyLibraries(srcDir, aol);
            File classesDirectory = new File(this.getOutputDirectory(), "classes");
            classesDirectory.mkdirs();
            List jars = FileUtils.getFiles((File)srcDir, (String)"**/*.jar", null);
            for (File jar : jars) {
                this.getLog().debug((CharSequence)("Unpacking jar " + jar));
                UnArchiver unArchiver = this.archiverManager.getUnArchiver("nar");
                unArchiver.setSourceFile(jar);
                unArchiver.setDestDirectory(classesDirectory);
                unArchiver.extract();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("NAR: Could not copy resources for " + aol, (Exception)e);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("NAR: Could not find archiver for " + aol, (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("NAR: Could not unarchive jar file for " + aol, (Exception)((Object)e));
        }
        this.getLog().info((CharSequence)("Copied " + copied + " resources for " + aol));
    }
}

