/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.NarProperties;
import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.types.CommandLineArgument;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LinkerArgument;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public class Java {
    @Parameter(required=true)
    private boolean include = false;
    @Parameter
    private List includePaths;
    @Parameter(required=true)
    private boolean link = false;
    @Parameter
    private String runtimeDirectory;
    @Parameter(defaultValue="jvm")
    private String runtime = "jvm";
    private AbstractCompileMojo mojo;

    public final void addIncludePaths(CCTask task, String outType) throws MojoFailureException, MojoExecutionException {
        block2: {
            String[] path;
            block3: {
                if (!this.include && !this.mojo.getJavah().getJniDirectory().exists()) break block2;
                if (this.includePaths == null) break block3;
                for (Object includePath : this.includePaths) {
                    String path2 = (String)includePath;
                    task.createIncludePath().setPath(new File(this.mojo.getJavaHome(this.mojo.getAOL()), path2).getPath());
                }
                break block2;
            }
            String prefix = this.mojo.getAOL().getKey() + ".java.";
            String includes = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(prefix + "include");
            if (includes == null) break block2;
            for (String element : path = includes.split(";")) {
                task.createIncludePath().setPath(new File(this.mojo.getJavaHome(this.mojo.getAOL()), element).getPath());
            }
        }
    }

    public final void addRuntime(CCTask task, File javaHome, String os, String prefix) throws MojoFailureException {
        if (this.link) {
            if (os.equals("MacOSX")) {
                CommandLineArgument.LocationEnum end = new CommandLineArgument.LocationEnum();
                end.setValue("end");
                LinkerArgument framework = new LinkerArgument();
                framework.setValue("-framework");
                framework.setLocation(end);
                task.addConfiguredLinkerArg(framework);
                LinkerArgument javavm = new LinkerArgument();
                javavm.setValue("JavaVM");
                javavm.setLocation(end);
                task.addConfiguredLinkerArg(javavm);
            } else {
                if (this.runtimeDirectory == null) {
                    this.runtimeDirectory = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(prefix + "runtimeDirectory");
                    if (this.runtimeDirectory == null) {
                        throw new MojoFailureException("NAR: Please specify a <RuntimeDirectory> as part of <Java>");
                    }
                }
                this.mojo.getLog().debug((CharSequence)("Using Java Runtime Directory: " + this.runtimeDirectory));
                LibrarySet libset = new LibrarySet();
                libset.setProject(this.mojo.getAntProject());
                libset.setLibs(new CUtil.StringArrayBuilder(this.runtime));
                libset.setDir(new File(javaHome, this.runtimeDirectory));
                task.addLibset(libset);
            }
        }
    }

    public final void setAbstractCompileMojo(AbstractCompileMojo mojo) {
        this.mojo = mojo;
    }
}

