/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractNarMojo;
import com.github.maven_nar.NarJavahMojo;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class Javah {
    @Parameter(defaultValue="javah")
    private String name = "javah";
    @Parameter
    private List bootClassPaths = new ArrayList();
    @Parameter
    private List classPaths = new ArrayList();
    @Parameter(defaultValue="${project.build.directory}/nar/javah-include", required=true)
    private File jniDirectory;
    @Parameter(defaultValue="${project.build.directory}/classes", required=true)
    private File classDirectory;
    @Parameter
    private Set includes = new HashSet();
    @Parameter
    private Set excludes = new HashSet();
    @Parameter
    private Set extraClasses = new HashSet();
    @Parameter(defaultValue="0", required=true)
    private int staleMillis = 0;
    @Parameter
    private File timestampDirectory;
    @Parameter
    private File timestampFile;
    private AbstractNarMojo mojo;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.getClassDirectory().mkdirs();
        try {
            StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis, this.getIncludes(), this.excludes);
            if (this.getTimestampDirectory().exists()) {
                scanner.addSourceMapping((SourceMapping)new SingleTargetSourceMapping(".class", this.getTimestampFile().getPath()));
            } else {
                scanner.addSourceMapping((SourceMapping)new SuffixMapping(".class", ".dummy"));
            }
            Set classes = scanner.getIncludedSources(this.getClassDirectory(), this.getTimestampDirectory());
            if (!classes.isEmpty()) {
                HashSet<String> files = new HashSet<String>();
                for (Object aClass : classes) {
                    Method[] method;
                    String file = ((File)aClass).getPath();
                    JavaClass clazz = NarUtil.getBcelClass(file);
                    for (Method element : method = clazz.getMethods()) {
                        if (!element.isNative()) continue;
                        files.add(clazz.getClassName());
                    }
                }
                if (!files.isEmpty()) {
                    this.getJniDirectory().mkdirs();
                    this.getTimestampDirectory().mkdirs();
                    String javah = this.getJavah();
                    this.mojo.getLog().info((CharSequence)("Running " + javah + " compiler on " + files.size() + " classes..."));
                    int result = NarUtil.runCommand(javah, this.generateArgs(files), null, null, this.mojo.getLog());
                    if (result != 0) {
                        throw new MojoFailureException(javah + " failed with exit code " + result + " 0x" + Integer.toHexString(result));
                    }
                    FileUtils.fileWrite((String)(this.getTimestampDirectory() + "/" + this.getTimestampFile()), (String)"");
                }
            }
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("JAVAH: Class scanning failed", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("JAVAH: IO Exception", (Exception)e);
        }
        catch (ClassFormatException e) {
            throw new MojoExecutionException("JAVAH: Class could not be inspected", (Exception)((Object)e));
        }
    }

    private String[] generateArgs(Set classes) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        if (!this.bootClassPaths.isEmpty()) {
            args.add("-bootclasspath");
            args.add(StringUtils.join(this.bootClassPaths.iterator(), (String)File.pathSeparator));
        }
        args.add("-classpath");
        args.add(StringUtils.join(this.getClassPaths().iterator(), (String)File.pathSeparator));
        args.add("-d");
        args.add(this.getJniDirectory().getPath());
        if (this.mojo.getLog().isDebugEnabled()) {
            args.add("-verbose");
        }
        if (classes != null) {
            for (Object aClass : classes) {
                args.add((String)aClass);
            }
        }
        if (this.extraClasses != null) {
            for (Object extraClass : this.extraClasses) {
                args.add((String)extraClass);
            }
        }
        return args.toArray(new String[args.size()]);
    }

    protected final File getClassDirectory() {
        if (this.classDirectory == null) {
            this.classDirectory = new File(this.mojo.getMavenProject().getBuild().getDirectory(), "classes");
        }
        return this.classDirectory;
    }

    protected final List getClassPaths() throws MojoExecutionException {
        if (this.classPaths.isEmpty()) {
            try {
                this.classPaths.addAll(this.mojo.getMavenProject().getCompileClasspathElements());
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("JAVAH, cannot get classpath", (Exception)((Object)e));
            }
        }
        return this.classPaths;
    }

    protected final Set getIncludes() {
        NarUtil.removeNulls(this.includes);
        if (this.includes.isEmpty()) {
            this.includes.add("**/*.class");
        }
        return this.includes;
    }

    private String getJavah() throws MojoExecutionException, MojoFailureException {
        String javah = null;
        Toolchain toolchain = this.getToolchain();
        if (toolchain != null) {
            javah = toolchain.findTool("javah");
        }
        if (javah == null) {
            File javahFile = new File(this.mojo.getJavaHome(this.mojo.getAOL()), "bin");
            javah = new File(javahFile, this.name).getAbsolutePath();
        }
        if (javah == null) {
            throw new MojoExecutionException("NAR: Cannot find 'javah' in Toolchain or on JavaHome");
        }
        return javah;
    }

    protected final File getJniDirectory() {
        if (this.jniDirectory == null) {
            this.jniDirectory = new File(this.mojo.getMavenProject().getBuild().getDirectory(), "nar/javah-include");
        }
        return this.jniDirectory;
    }

    protected final File getTimestampDirectory() {
        if (this.timestampDirectory == null) {
            this.timestampDirectory = this.getJniDirectory();
        }
        return this.timestampDirectory;
    }

    protected final File getTimestampFile() {
        if (this.timestampFile == null) {
            this.timestampFile = new File(this.name);
        }
        return this.timestampFile;
    }

    private Toolchain getToolchain() {
        Toolchain toolChain = null;
        ToolchainManager toolchainManager = ((NarJavahMojo)this.mojo).getToolchainManager();
        if (toolchainManager != null) {
            toolChain = toolchainManager.getToolchainFromBuildContext("jdk", ((NarJavahMojo)this.mojo).getSession());
        }
        return toolChain;
    }

    public final void setAbstractCompileMojo(AbstractNarMojo abstractNarMojo) {
        this.mojo = abstractNarMojo;
    }
}

