/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractGnuMojo;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="nar-gnu-configure", requiresProject=true, defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class NarGnuConfigureMojo
extends AbstractGnuMojo {
    private static final String AUTOGEN = "autogen.sh";
    private static final String BUILDCONF = "buildconf";
    private static final String CONFIGURE = "configure";
    @Parameter(property="nar.gnu.configure.in-place")
    private boolean gnuConfigureInPlace;
    @Parameter(property="nar.gnu.autogen.skip")
    private boolean gnuAutogenSkip;
    @Parameter(property="nar.gnu.configure.skip")
    private boolean gnuConfigureSkip;
    @Parameter(property="nar.gnu.configure.args", defaultValue="")
    private String gnuConfigureArgs;
    @Parameter(property="nar.gnu.buildconf.args", defaultValue="")
    private String gnuBuildconfArgs;

    private static String arraysToString(Object[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    @Override
    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.useGnu()) {
            return;
        }
        File sourceDir = this.getGnuSourceDirectory();
        if (sourceDir.exists()) {
            File targetDir;
            if (!this.gnuConfigureInPlace) {
                targetDir = this.getGnuAOLSourceDirectory();
                this.getLog().info((CharSequence)"Copying GNU sources");
                try {
                    FileUtils.mkdir((String)targetDir.getPath());
                    NarUtil.copyDirectoryStructure(sourceDir, targetDir, null, null);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy GNU sources", (Exception)e);
                }
                if (!this.gnuConfigureSkip && !this.gnuAutogenSkip) {
                    File autogen = new File(targetDir, AUTOGEN);
                    File buildconf = new File(targetDir, BUILDCONF);
                    if (autogen.exists()) {
                        this.getLog().info((CharSequence)"Running GNU autogen.sh");
                        this.runAutogen(autogen, targetDir, null);
                    } else if (buildconf.exists()) {
                        this.getLog().info((CharSequence)"Running GNU buildconf");
                        String[] gnuBuildconfArgsArray = null;
                        if (this.gnuBuildconfArgs != null) {
                            gnuBuildconfArgsArray = this.gnuBuildconfArgs.split("\\s");
                        }
                        this.runAutogen(buildconf, targetDir, gnuBuildconfArgsArray);
                    }
                }
            } else {
                targetDir = sourceDir;
            }
            File configure = new File(targetDir, CONFIGURE);
            if (!this.gnuConfigureSkip && configure.exists()) {
                this.getLog().info((CharSequence)"Running GNU configure");
                NarUtil.makeExecutable(configure, this.getLog());
                Object[] args = null;
                if (this.gnuConfigureArgs != null) {
                    String[] a = this.gnuConfigureArgs.split(" ");
                    args = new String[a.length + 2];
                    System.arraycopy(a, 0, args, 2, a.length);
                } else {
                    args = new String[]{configure.getAbsolutePath(), "--prefix=" + this.getGnuAOLTargetDirectory().getAbsolutePath()};
                }
                File buildDir = this.getGnuAOLSourceDirectory();
                FileUtils.mkdir((String)buildDir.getPath());
                this.getLog().info((CharSequence)("args: " + NarGnuConfigureMojo.arraysToString(args)));
                int result = NarUtil.runCommand("sh", (String[])args, buildDir, null, this.getLog());
                if (result != 0) {
                    throw new MojoExecutionException("'configure' errorcode: " + result);
                }
            }
        }
    }

    private void runAutogen(File autogen, File targetDir, String[] args) throws MojoExecutionException, MojoFailureException {
        File configDir = new File(targetDir, "config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        NarUtil.makeExecutable(autogen, this.getLog());
        this.getLog().debug((CharSequence)("running sh ./" + autogen.getName()));
        Object[] arguments = null;
        if (args != null) {
            arguments = new String[1 + args.length];
            System.arraycopy(args, 0, arguments, 1, args.length);
        } else {
            arguments = new String[]{"./" + autogen.getName()};
        }
        this.getLog().info((CharSequence)("args: " + NarGnuConfigureMojo.arraysToString(arguments)));
        int result = NarUtil.runCommand("sh", (String[])arguments, targetDir, null, this.getLog());
        if (result != 0) {
            throw new MojoExecutionException("'" + autogen.getName() + "' errorcode: " + result);
        }
    }
}

