/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.PropertyUtils;

public class NarProperties {
    private static final String AOL_PROPERTIES = "aol.properties";
    private static final String CUSTOM_AOL_PROPERTY_KEY = "nar.aolProperties";
    private static NarProperties instance;
    private final Properties properties;

    public static NarProperties getInstance(MavenProject project) throws MojoFailureException {
        if (instance == null) {
            instance = new NarProperties(project);
        }
        return instance;
    }

    public static void inject(MavenProject project, InputStream properties) throws MojoFailureException {
        Properties defaults = PropertyUtils.loadProperties((InputStream)properties);
        NarProperties nar = NarProperties.getInstance(project);
        nar.properties.putAll((Map<?, ?>)defaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NarProperties(MavenProject project) throws MojoFailureException {
        Properties defaults = PropertyUtils.loadProperties((InputStream)NarUtil.class.getResourceAsStream(AOL_PROPERTIES));
        if (defaults == null) {
            throw new MojoFailureException("NAR: Could not load default properties file: 'aol.properties'.");
        }
        this.properties = new Properties(defaults);
        FileInputStream fis = null;
        String customPropertyLocation = null;
        try {
            if (project != null) {
                customPropertyLocation = project.getProperties().getProperty(CUSTOM_AOL_PROPERTY_KEY);
                if (customPropertyLocation == null) {
                    customPropertyLocation = System.getProperties().getProperty(CUSTOM_AOL_PROPERTY_KEY);
                }
                fis = new FileInputStream(customPropertyLocation != null ? customPropertyLocation : project.getBasedir() + File.separator + AOL_PROPERTIES);
                this.properties.load(fis);
            }
        }
        catch (FileNotFoundException e) {
            if (customPropertyLocation != null) {
                throw new MojoFailureException("NAR: Could not load custom properties file: '" + customPropertyLocation + "'.");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Collection<String> getKnownAOLs() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Pattern pattern = Pattern.compile("([^.]+)\\.([^.]+)\\.([^.]+).*");
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            Matcher matcher;
            Object key = e.nextElement();
            if (!(key instanceof String) || !(matcher = pattern.matcher((String)key)).matches()) continue;
            result.add(matcher.group(1) + "-" + matcher.group(2) + "-" + matcher.group(3));
        }
        return result;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }
}

