/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.Linker;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;

@Mojo(name="nar-validate", defaultPhase=LifecyclePhase.VALIDATE)
public class NarValidateMojo
extends AbstractCompileMojo {
    @Parameter(defaultValue="${basedir}/src/gnu", required=true)
    private File gnuSourceDirectory;

    @Override
    protected ScopeFilter getArtifactScopeFilter() {
        return null;
    }

    @Override
    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)(this.getClass().getName() + " skipped"));
            return;
        }
        AOL aol = this.getAOL();
        this.getLog().info((CharSequence)("Using AOL: " + aol));
        Linker linker = this.getLinker();
        this.getLog().debug((CharSequence)("Using linker version: " + linker.getVersion(this)));
        int noOfCompilers = 0;
        if (this.onlySpecifiedCompilers) {
            if (this.getCpp() != null && this.getCpp().getName() != null) {
                ++noOfCompilers;
                if (this.getCpp().getIncludes("main").isEmpty()) {
                    throw new MojoExecutionException("No includes defined for compiler " + this.getCpp().getName());
                }
            }
            if (this.getC() != null && this.getC().getName() != null) {
                ++noOfCompilers;
                if (this.getC().getIncludes("main").isEmpty()) {
                    throw new MojoExecutionException("No includes defined for compiler " + this.getC().getName());
                }
            }
            if (this.getFortran() != null && this.getFortran().getName() != null) {
                ++noOfCompilers;
                if (this.getFortran().getIncludes("main").isEmpty()) {
                    throw new MojoExecutionException("No includes defined for compiler " + this.getFortran().getName());
                }
            }
            if (!(noOfCompilers != 0 || this.gnuSourceDirectory != null && this.gnuSourceDirectory.exists())) {
                throw new MojoExecutionException("No compilers defined for linker " + linker.getName() + ", and no" + " <gnuSourceDirectory> is defined.  Either define a compiler or a linker.");
            }
        }
    }
}

