/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.SourceHistory;
import com.github.maven_nar.cpptasks.compiler.ProcessorConfiguration;
import java.io.File;

public final class TargetInfo {
    private static final File[] emptyFileArray = new File[0];
    private final ProcessorConfiguration config;
    private final File output;
    private boolean rebuild;
    private final File[] sources;
    private File[] sysSources;

    public TargetInfo(ProcessorConfiguration config, File[] sources, File[] sysSources, File output, boolean rebuild) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        if (sources == null) {
            throw new NullPointerException("sources");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        this.config = config;
        this.sources = (File[])sources.clone();
        this.sysSources = sysSources == null ? emptyFileArray : (File[])sysSources.clone();
        this.output = output;
        this.rebuild = rebuild;
        if (!output.exists()) {
            rebuild = true;
        }
    }

    public String[] getAllSourcePaths() {
        String[] paths = new String[this.sysSources.length + this.sources.length];
        for (int i = 0; i < this.sysSources.length; ++i) {
            paths[i] = this.sysSources[i].toString();
        }
        int offset = this.sysSources.length;
        for (int i = 0; i < this.sources.length; ++i) {
            paths[offset + i] = this.sources[i].toString();
        }
        return paths;
    }

    public File[] getAllSources() {
        File[] allSources = new File[this.sources.length + this.sysSources.length];
        System.arraycopy(this.sysSources, 0, allSources, 0, this.sysSources.length);
        int offset = this.sysSources.length;
        System.arraycopy(this.sources, 0, allSources, 0 + offset, this.sources.length);
        return allSources;
    }

    public ProcessorConfiguration getConfiguration() {
        return this.config;
    }

    public File getOutput() {
        return this.output;
    }

    public boolean getRebuild() {
        return this.rebuild;
    }

    public SourceHistory[] getSourceHistories(String basePath) {
        SourceHistory[] histories = new SourceHistory[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            String relativeName = CUtil.getRelativePath(basePath, this.sources[i]);
            long lastModified = this.sources[i].lastModified();
            histories[i] = new SourceHistory(relativeName, lastModified);
        }
        return histories;
    }

    public String[] getSourcePaths() {
        String[] paths = new String[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            paths[i] = this.sources[i].toString();
        }
        return paths;
    }

    public File[] getSources() {
        File[] clone = (File[])this.sources.clone();
        return clone;
    }

    public String[] getSysSourcePaths() {
        String[] paths = new String[this.sysSources.length];
        for (int i = 0; i < this.sysSources.length; ++i) {
            paths[i] = this.sysSources[i].toString();
        }
        return paths;
    }

    public File[] getSysSources() {
        File[] clone = (File[])this.sysSources.clone();
        return clone;
    }

    public void mustRebuild() {
        this.rebuild = true;
    }
}

