/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.compiler;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.ProcessorDef;
import com.github.maven_nar.cpptasks.ProcessorParam;
import com.github.maven_nar.cpptasks.TargetDef;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.AbstractCompiler;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.CompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.ProgressMonitor;
import com.github.maven_nar.cpptasks.types.CommandLineArgument;
import com.github.maven_nar.cpptasks.types.UndefineArgument;
import com.google.common.collect.ObjectArrays;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.util.FileUtils;

public abstract class CommandLineCompiler
extends AbstractCompiler {
    private static final String CCACHE_CMD = "ccache";
    private String command;
    private String prefix;
    private final Environment env;
    private String identifier;
    private final String identifierArg;
    private final boolean libtool;
    private final CommandLineCompiler libtoolCompiler;
    private final boolean newEnvironment;

    protected CommandLineCompiler(String command, String identifierArg, String[] sourceExtensions, String[] headerExtensions, String outputSuffix, boolean libtool, CommandLineCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(sourceExtensions, headerExtensions, outputSuffix);
        this.command = command;
        if (libtool && libtoolCompiler != null) {
            throw new IllegalArgumentException("libtoolCompiler should be null when libtool is true");
        }
        this.libtool = libtool;
        this.libtoolCompiler = libtoolCompiler;
        this.identifierArg = identifierArg;
        this.newEnvironment = newEnvironment;
        this.env = env;
    }

    protected abstract void addImpliedArgs(Vector<String> var1, boolean var2, boolean var3, boolean var4, LinkType var5, Boolean var6, OptimizationEnum var7);

    protected void addIncludes(String baseDirPath, File[] includeDirs, Vector<String> args, Vector<String> relativeArgs, StringBuffer includePathId, boolean isSystem) {
        for (File includeDir : includeDirs) {
            args.addElement(this.getIncludeDirSwitch(includeDir.getAbsolutePath(), isSystem));
            if (relativeArgs == null) continue;
            String relative = CUtil.getRelativePath(baseDirPath, includeDir);
            relativeArgs.addElement(this.getIncludeDirSwitch(relative, isSystem));
            if (includePathId == null) continue;
            if (includePathId.length() == 0) {
                includePathId.append("/I");
            } else {
                includePathId.append(" /I");
            }
            includePathId.append(relative);
        }
    }

    protected abstract void addWarningSwitch(Vector<String> var1, int var2);

    protected void buildDefineArguments(CompilerDef[] defs, Vector<String> args) {
        UndefineArgument[] merged = defs[0].getActiveDefines();
        for (int i = 1; i < defs.length; ++i) {
            merged = UndefineArgument.merge(defs[i].getActiveDefines(), merged);
        }
        StringBuffer buf = new StringBuffer(30);
        for (UndefineArgument current : merged) {
            buf.setLength(0);
            if (current.isDefine()) {
                this.getDefineSwitch(buf, current.getName(), current.getValue());
            } else {
                this.getUndefineSwitch(buf, current.getName());
            }
            args.addElement(buf.toString());
        }
    }

    @Override
    public String[] getOutputFileNames(String inputFile, VersionInfo versionInfo) {
        if (this.bid(inputFile) > 1) {
            String baseName = this.getBaseOutputName(inputFile);
            File standardisedFile = new File(inputFile);
            try {
                return new String[]{baseName + '.' + Integer.toHexString(standardisedFile.getCanonicalPath().hashCode()) + this.getOutputSuffix()};
            }
            catch (IOException e) {
                throw new BuildException("Source file not found", (Throwable)e);
            }
        }
        return new String[0];
    }

    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) throws BuildException {
        BuildException exc = null;
        String command = this.getCommandWithPath(config);
        if (config.isUseCcache()) {
            String compilerCommand = command;
            command = CCACHE_CMD;
            args = (String[])ObjectArrays.concat((Object)compilerCommand, (Object[])args);
        }
        int baseLength = command.length() + args.length + endArgs.length;
        if (this.libtool) {
            baseLength += 8;
        }
        for (String arg : args) {
            baseLength += arg.length();
        }
        for (String endArg : endArgs) {
            baseLength += endArg.length();
        }
        if (baseLength > this.getMaximumCommandLength()) {
            throw new BuildException("Command line is over maximum length without specifying source file");
        }
        int maxInputFilesPerCommand = this.getMaximumInputFilesPerCommand();
        int argumentCountPerInputFile = this.getArgumentCountPerInputFile();
        int sourceIndex = 0;
        while (sourceIndex < sourceFiles.length) {
            int firstFileNextExec;
            int cmdLength = baseLength;
            for (firstFileNextExec = sourceIndex; firstFileNextExec < sourceFiles.length && firstFileNextExec - sourceIndex < maxInputFilesPerCommand && (cmdLength += this.getTotalArgumentLengthForInputFile(outputDir, sourceFiles[firstFileNextExec])) < this.getMaximumCommandLength(); ++firstFileNextExec) {
            }
            if (firstFileNextExec == sourceIndex) {
                throw new BuildException("Extremely long file name, can't fit on command line");
            }
            ArrayList<String> commandlinePrefix = new ArrayList<String>();
            if (this.libtool) {
                commandlinePrefix.add("libtool");
            }
            commandlinePrefix.add(command);
            Collections.addAll(commandlinePrefix, args);
            int retval = 0;
            for (int j = sourceIndex; j < firstFileNextExec; ++j) {
                ArrayList<String> commandlineSuffix = new ArrayList<String>();
                for (int k = 0; k < argumentCountPerInputFile; ++k) {
                    commandlineSuffix.add(this.getInputFileArgument(outputDir, sourceFiles[j], k));
                }
                Collections.addAll(commandlineSuffix, endArgs);
                ArrayList<String> commandline = new ArrayList<String>(commandlinePrefix);
                commandline.addAll(commandlineSuffix);
                int ret = this.runCommand(task, this.workDir, commandline.toArray(new String[commandline.size()]));
                if (ret == 0) continue;
                retval = ret;
            }
            if (monitor != null) {
                String[] fileNames = new String[firstFileNextExec - sourceIndex];
                System.arraycopy(sourceFiles, sourceIndex + 0, fileNames, 0, fileNames.length);
                monitor.progress(fileNames);
            }
            if (retval != 0 && exc == null) {
                exc = new BuildException(this.getCommandWithPath(config) + " failed with return code " + retval, task.getLocation());
                if (!relentless) {
                    throw exc;
                }
            }
            sourceIndex = firstFileNextExec;
        }
        if (exc != null) {
            throw exc;
        }
    }

    @Override
    protected CompilerConfiguration createConfiguration(CCTask task, LinkType linkType, ProcessorDef[] baseDefs, CompilerDef specificDef, TargetDef targetPlatform, VersionInfo versionInfo) {
        String baseDirPath;
        ProcessorParam[] paramArray;
        Object arg;
        this.prefix = specificDef.getCompilerPrefix();
        this.objDir = task.getObjdir();
        Vector<String> args = new Vector<String>();
        CompilerDef[] defaultProviders = new CompilerDef[baseDefs.length + 1];
        for (int i = 0; i < baseDefs.length; ++i) {
            defaultProviders[i + 1] = (CompilerDef)baseDefs[i];
        }
        defaultProviders[0] = specificDef;
        Vector<CommandLineArgument> cmdArgs = new Vector<CommandLineArgument>();
        for (int i = defaultProviders.length - 1; i >= 0; --i) {
            CommandLineArgument[] commandArgs;
            for (CommandLineArgument commandArg : commandArgs = defaultProviders[i].getActiveProcessorArgs()) {
                if (commandArg.getLocation() == 0) {
                    arg = commandArg.getValue();
                    if (this.isWindows() && ((String)arg).matches(".*[ \"].*")) {
                        arg = "\"" + ((String)arg).replaceAll("[\\\\\"]", "\\\\$0") + "\"";
                    }
                    args.addElement((String)arg);
                    continue;
                }
                cmdArgs.addElement(commandArg);
            }
        }
        Vector params = new Vector();
        for (int i = defaultProviders.length - 1; i >= 0; --i) {
            paramArray = defaultProviders[i].getActiveProcessorParams();
            Collections.addAll(params, paramArray);
        }
        paramArray = params.toArray(new ProcessorParam[params.size()]);
        if (!specificDef.isClearDefaultOptions()) {
            boolean multithreaded = specificDef.getMultithreaded(defaultProviders, 1);
            boolean debug = specificDef.getDebug(baseDefs, 0);
            boolean exceptions = specificDef.getExceptions(defaultProviders, 1);
            Boolean rtti = specificDef.getRtti(defaultProviders, 1);
            OptimizationEnum optimization = specificDef.getOptimization(defaultProviders, 1);
            this.addImpliedArgs(args, debug, multithreaded, exceptions, linkType, rtti, optimization);
        }
        this.buildDefineArguments(defaultProviders, args);
        int warnings = specificDef.getWarnings(defaultProviders, 0);
        this.addWarningSwitch(args, warnings);
        Enumeration argEnum = cmdArgs.elements();
        int endCount = 0;
        while (argEnum.hasMoreElements()) {
            arg = (CommandLineArgument)argEnum.nextElement();
            switch (((CommandLineArgument)arg).getLocation()) {
                case 1: {
                    args.addElement(((CommandLineArgument)arg).getValue());
                    break;
                }
                case 2: {
                    ++endCount;
                }
            }
        }
        String[] endArgs = new String[endCount];
        argEnum = cmdArgs.elements();
        int index = 0;
        while (argEnum.hasMoreElements()) {
            CommandLineArgument arg2 = (CommandLineArgument)argEnum.nextElement();
            if (arg2.getLocation() != 2) continue;
            endArgs[index++] = arg2.getValue();
        }
        Vector relativeArgs = (Vector)args.clone();
        StringBuffer includePathIdentifier = new StringBuffer();
        File baseDir = specificDef.getProject().getBaseDir();
        try {
            baseDirPath = baseDir.getCanonicalPath();
        }
        catch (IOException ex) {
            baseDirPath = baseDir.toString();
        }
        Vector<String> includePath = new Vector<String>();
        Vector<String> sysIncludePath = new Vector<String>();
        for (int i = defaultProviders.length - 1; i >= 0; --i) {
            String[] incPath;
            for (String element : incPath = defaultProviders[i].getActiveIncludePaths()) {
                includePath.addElement(element);
            }
            for (String element : incPath = defaultProviders[i].getActiveSysIncludePaths()) {
                sysIncludePath.addElement(element);
            }
        }
        File[] incPath = new File[includePath.size()];
        for (int i = 0; i < includePath.size(); ++i) {
            incPath[i] = new File((String)includePath.elementAt(i));
        }
        File[] sysIncPath = new File[sysIncludePath.size()];
        for (int i = 0; i < sysIncludePath.size(); ++i) {
            sysIncPath[i] = new File((String)sysIncludePath.elementAt(i));
        }
        this.addIncludes(baseDirPath, incPath, args, relativeArgs, includePathIdentifier, false);
        this.addIncludes(baseDirPath, sysIncPath, args, null, null, true);
        StringBuffer buf = new StringBuffer(this.getIdentifier());
        for (int i = 0; i < relativeArgs.size(); ++i) {
            buf.append(' ');
            buf.append((String)relativeArgs.elementAt(i));
        }
        for (String endArg : endArgs) {
            buf.append(' ');
            buf.append(endArg);
        }
        String configId = buf.toString();
        Object[] argArray = new String[args.size()];
        args.copyInto(argArray);
        boolean rebuild = specificDef.getRebuild(baseDefs, 0);
        File[] envIncludePath = this.getEnvironmentIncludePath();
        String path = specificDef.getToolPath();
        CommandLineCompiler compiler = this;
        Environment environment = specificDef.getEnv();
        if (environment == null) {
            for (ProcessorDef baseDef : baseDefs) {
                environment = baseDef.getEnv();
                if (environment == null) continue;
                compiler = (CommandLineCompiler)compiler.changeEnvironment(baseDef.isNewEnvironment(), environment);
            }
        } else {
            compiler = (CommandLineCompiler)compiler.changeEnvironment(specificDef.isNewEnvironment(), environment);
        }
        return new CommandLineCompilerConfiguration(compiler, configId, incPath, sysIncPath, envIncludePath, includePathIdentifier.toString(), (String[])argArray, paramArray, rebuild, endArgs, path, specificDef.getCcache());
    }

    protected int getArgumentCountPerInputFile() {
        return 1;
    }

    protected final String getCommand() {
        if (this.prefix != null && !this.prefix.isEmpty()) {
            return this.prefix + this.command;
        }
        return this.command;
    }

    public String getCommandWithPath(CommandLineCompilerConfiguration config) {
        if (config.getCommandPath() != null) {
            File command = new File(config.getCommandPath(), this.getCommand());
            try {
                return command.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
                return command.getAbsolutePath();
            }
        }
        return this.getCommand();
    }

    protected abstract void getDefineSwitch(StringBuffer var1, String var2, String var3);

    protected abstract File[] getEnvironmentIncludePath();

    @Override
    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.identifierArg == null ? CommandLineCompiler.getIdentifier(new String[]{this.getCommand()}, this.getCommand()) : CommandLineCompiler.getIdentifier(new String[]{this.getCommand(), this.identifierArg}, this.getCommand());
        }
        return this.identifier;
    }

    protected abstract String getIncludeDirSwitch(String var1);

    protected String getIncludeDirSwitch(String source, boolean isSystem) {
        return this.getIncludeDirSwitch(source);
    }

    protected String getInputFileArgument(File outputDir, String filename, int index) {
        String relative = "";
        try {
            relative = FileUtils.getRelativePath((File)this.workDir, (File)new File(filename));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String inputFile = relative.isEmpty() ? filename : relative;
        if (inputFile.indexOf(32) >= 0) {
            String buf = "\"" + inputFile + "\"";
            return buf;
        }
        return inputFile;
    }

    protected final boolean getLibtool() {
        return this.libtool;
    }

    public final CommandLineCompiler getLibtoolCompiler() {
        if (this.libtoolCompiler != null) {
            return this.libtoolCompiler;
        }
        return this;
    }

    public abstract int getMaximumCommandLength();

    protected int getMaximumInputFilesPerCommand() {
        return Integer.MAX_VALUE;
    }

    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        int argumentCountPerInputFile = this.getArgumentCountPerInputFile();
        int len = 0;
        for (int k = 0; k < argumentCountPerInputFile; ++k) {
            len += this.getInputFileArgument(outputDir, inputFile, k).length();
        }
        return len + argumentCountPerInputFile;
    }

    protected abstract void getUndefineSwitch(StringBuffer var1, String var2);

    protected int runCommand(CCTask task, File workingDir, String[] cmdline) throws BuildException {
        return CUtil.runCommand(task, workingDir, cmdline, this.newEnvironment, this.env);
    }

    protected final void setCommand(String command) {
        this.command = command;
    }
}

