/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.compiler;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CompilerParam;
import com.github.maven_nar.cpptasks.DependencyInfo;
import com.github.maven_nar.cpptasks.ProcessorParam;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.Compiler;
import com.github.maven_nar.cpptasks.compiler.CompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.PrecompilingCompiler;
import com.github.maven_nar.cpptasks.compiler.ProgressMonitor;
import java.io.File;
import org.apache.tools.ant.BuildException;

public final class CommandLineCompilerConfiguration
implements CompilerConfiguration {
    private boolean useCcache;
    private String[] args;
    private final CommandLineCompiler compiler;
    private final String[] endArgs;
    private File[] envIncludePath;
    private String[] exceptFiles;
    private final String identifier;
    private File[] includePath;
    private final String includePathIdentifier;
    private final boolean isPrecompiledHeaderGeneration;
    private ProcessorParam[] params;
    private final boolean rebuild;
    private File[] sysIncludePath;
    private String commandPath;

    public CommandLineCompilerConfiguration(CommandLineCompiler compiler, String identifier, File[] includePath, File[] sysIncludePath, File[] envIncludePath, String includePathIdentifier, String[] args, ProcessorParam[] params, boolean rebuild, String[] endArgs) {
        this(compiler, identifier, includePath, sysIncludePath, envIncludePath, includePathIdentifier, args, params, rebuild, endArgs, null);
    }

    public CommandLineCompilerConfiguration(CommandLineCompiler compiler, String identifier, File[] includePath, File[] sysIncludePath, File[] envIncludePath, String includePathIdentifier, String[] args, ProcessorParam[] params, boolean rebuild, String[] endArgs, String commandPath) {
        this(compiler, identifier, includePath, sysIncludePath, envIncludePath, includePathIdentifier, args, params, rebuild, endArgs, commandPath, false);
    }

    public CommandLineCompilerConfiguration(CommandLineCompiler compiler, String identifier, File[] includePath, File[] sysIncludePath, File[] envIncludePath, String includePathIdentifier, String[] args, ProcessorParam[] params, boolean rebuild, String[] endArgs, String commandPath, boolean useCcache) {
        if (compiler == null) {
            throw new NullPointerException("compiler");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier");
        }
        if (includePathIdentifier == null) {
            throw new NullPointerException("includePathIdentifier");
        }
        this.args = args == null ? new String[0] : (String[])args.clone();
        this.includePath = includePath == null ? new File[0] : (File[])includePath.clone();
        this.sysIncludePath = sysIncludePath == null ? new File[0] : (File[])sysIncludePath.clone();
        this.envIncludePath = envIncludePath == null ? new File[0] : (File[])envIncludePath.clone();
        this.useCcache = useCcache;
        this.compiler = compiler;
        this.params = (ProcessorParam[])params.clone();
        this.rebuild = rebuild;
        this.identifier = identifier;
        this.includePathIdentifier = includePathIdentifier;
        this.endArgs = (String[])endArgs.clone();
        this.exceptFiles = null;
        this.isPrecompiledHeaderGeneration = false;
        this.commandPath = commandPath;
    }

    public CommandLineCompilerConfiguration(CommandLineCompilerConfiguration base, String[] additionalArgs, String[] exceptFiles, boolean isPrecompileHeaderGeneration) {
        this.compiler = base.compiler;
        this.identifier = base.identifier;
        this.rebuild = base.rebuild;
        this.includePath = (File[])base.includePath.clone();
        this.sysIncludePath = (File[])base.sysIncludePath.clone();
        this.endArgs = (String[])base.endArgs.clone();
        this.envIncludePath = (File[])base.envIncludePath.clone();
        this.includePathIdentifier = base.includePathIdentifier;
        if (exceptFiles != null) {
            this.exceptFiles = (String[])exceptFiles.clone();
        }
        this.isPrecompiledHeaderGeneration = isPrecompileHeaderGeneration;
        if (additionalArgs != null) {
            this.args = new String[base.args.length + additionalArgs.length];
            System.arraycopy(base.args, 0, this.args, 0, base.args.length);
            int index = base.args.length;
            for (String additionalArg : additionalArgs) {
                this.args[index++] = additionalArg;
            }
        } else {
            this.args = (String[])base.args.clone();
        }
        this.commandPath = base.commandPath;
    }

    @Override
    public int bid(String inputFile) {
        int compilerBid = this.compiler.bid(inputFile);
        if (compilerBid > 0 && this.exceptFiles != null) {
            for (String exceptFile : this.exceptFiles) {
                if (!inputFile.equals(exceptFile)) continue;
                return 0;
            }
        }
        return compilerBid;
    }

    @Override
    public void compile(CCTask task, File outputDir, String[] sourceFiles, boolean relentless, ProgressMonitor monitor) throws BuildException {
        if (monitor != null) {
            monitor.start(this);
        }
        try {
            this.compiler.compile(task, outputDir, sourceFiles, this.args, this.endArgs, relentless, this, monitor);
            if (monitor != null) {
                monitor.finish(this, true);
            }
        }
        catch (BuildException ex) {
            if (monitor != null) {
                monitor.finish(this, false);
            }
            throw ex;
        }
    }

    @Override
    public CompilerConfiguration[] createPrecompileConfigurations(File prototype, String[] nonPrecompiledFiles) {
        if (this.compiler instanceof PrecompilingCompiler) {
            return ((PrecompilingCompiler)((Object)this.compiler)).createPrecompileConfigurations(this, prototype, nonPrecompiledFiles);
        }
        return null;
    }

    public String getCommand() {
        return this.compiler.getCommand();
    }

    public final String getCommandPath() {
        return this.commandPath;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public String[] getEndArguments() {
        return (String[])this.endArgs.clone();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public File[] getIncludePath() {
        return (File[])this.includePath.clone();
    }

    @Override
    public String getIncludePathIdentifier() {
        return this.includePathIdentifier;
    }

    @Override
    public String[] getOutputFileNames(String inputFile, VersionInfo versionInfo) {
        return this.compiler.getOutputFileNames(inputFile, versionInfo);
    }

    @Override
    public CompilerParam getParam(String name) {
        for (ProcessorParam param : this.params) {
            if (!name.equals(param.getName())) continue;
            return (CompilerParam)param;
        }
        return null;
    }

    @Override
    public ProcessorParam[] getParams() {
        return this.params;
    }

    public String[] getPreArguments() {
        return (String[])this.args.clone();
    }

    @Override
    public boolean getRebuild() {
        return this.rebuild;
    }

    @Override
    public boolean isPrecompileGeneration() {
        return this.isPrecompiledHeaderGeneration;
    }

    public boolean isUseCcache() {
        return this.useCcache;
    }

    @Override
    public DependencyInfo parseIncludes(CCTask task, File baseDir, File source) {
        return this.compiler.parseIncludes(task, source, this.includePath, this.sysIncludePath, this.envIncludePath, baseDir, this.getIncludePathIdentifier());
    }

    public final void setCommandPath(String commandPath) {
        this.commandPath = commandPath;
    }

    public String toString() {
        return this.identifier;
    }
}

