/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.compiler;

import com.github.maven_nar.cpptasks.OutputTypeEnum;
import com.github.maven_nar.cpptasks.SubsystemEnum;

public class LinkType {
    private OutputTypeEnum outputType = new OutputTypeEnum();
    private boolean staticRuntime = false;
    private SubsystemEnum subsystem = new SubsystemEnum();
    private boolean linkCPP = true;
    private boolean linkFortran = false;
    private boolean linkFortranMain = false;

    public String getOutputType() {
        return this.outputType.getValue();
    }

    public String getSubsystem() {
        return this.subsystem.getValue();
    }

    public boolean isExecutable() {
        String value = this.outputType.getValue();
        return value.equals("executable");
    }

    public boolean isJNIModule() {
        String value = this.outputType.getValue();
        return value.equals("jni");
    }

    public boolean isPluginModule() {
        String value = this.outputType.getValue();
        return value.equals("plugin");
    }

    public boolean isSharedLibrary() {
        String value = this.outputType.getValue();
        return value.equals("shared") || value.equals("plugin") || value.equals("jni");
    }

    public boolean isStaticLibrary() {
        String value = this.outputType.getValue();
        return value.equals("static");
    }

    public boolean isStaticRuntime() {
        return this.staticRuntime;
    }

    public boolean isSubsystemConsole() {
        String value = this.subsystem.getValue();
        return value.equals("console");
    }

    public boolean isSubsystemGUI() {
        String value = this.subsystem.getValue();
        return value.equals("gui");
    }

    public boolean linkCPP() {
        return this.linkCPP;
    }

    public boolean linkFortran() {
        return this.linkFortran;
    }

    public boolean linkFortranMain() {
        return this.linkFortranMain;
    }

    public void setLinkCPP(boolean linkCPP) {
        this.linkCPP = linkCPP;
    }

    public void setLinkFortran(boolean linkFortran) {
        this.linkFortran = linkFortran;
    }

    public void setLinkFortranMain(boolean linkFortranMain) {
        this.linkFortranMain = linkFortranMain;
    }

    public void setOutputType(OutputTypeEnum outputType) {
        if (outputType == null) {
            throw new IllegalArgumentException("outputType");
        }
        this.outputType = outputType;
    }

    public void setStaticRuntime(boolean staticRuntime) {
        this.staticRuntime = staticRuntime;
    }

    public void setSubsystem(SubsystemEnum subsystem) {
        if (subsystem == null) {
            throw new IllegalArgumentException("subsystem");
        }
        this.subsystem = subsystem;
    }
}

