/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.gcc;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.gcc.AbstractLdLinker;
import com.github.maven_nar.cpptasks.gcc.GccLibrarian;
import com.github.maven_nar.cpptasks.gcc.GccProcessor;
import java.io.File;
import java.util.Vector;

public class GccLinker
extends AbstractLdLinker {
    private static final String[] discardFiles = new String[0];
    private static final String[] objFiles = new String[]{".o", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final String[] libtoolObjFiles = new String[]{".fo", ".a", ".lib", ".dll", ".so", ".sl"};
    private static String[] linkerOptions = new String[]{"-bundle", "-dynamic", "-arch", "-dynamiclib", "-nostartfiles", "-nostdlib", "-prebind", "-s", "-static", "-shared", "-symbolic", "-Xlinker", "--export-all-symbols", "-static-libgcc", "-p", "-pg", "-pthread"};
    private static final GccLinker soLinker = new GccLinker("gcc", objFiles, discardFiles, "lib", ".so", false, new GccLinker("gcc", objFiles, discardFiles, "lib", ".so", true, null));
    private static final GccLinker instance = new GccLinker("gcc", objFiles, discardFiles, "", "", false, null);
    private static final GccLinker clangInstance = new GccLinker("clang", objFiles, discardFiles, "", "", false, null);
    private static final GccLinker machBundleLinker = new GccLinker("gcc", objFiles, discardFiles, "lib", ".bundle", false, null);
    private static final GccLinker machDllLinker = new GccLinker("gcc", objFiles, discardFiles, "lib", ".dylib", false, null);
    private static final GccLinker machJNILinker = new GccLinker("gcc", objFiles, discardFiles, "lib", ".jnilib", false, null);
    private static final GccLinker dllLinker = new GccLinker("gcc", objFiles, discardFiles, "", ".dll", false, null);
    private File[] libDirs;

    public static GccLinker getCLangInstance() {
        return clangInstance;
    }

    public static GccLinker getInstance() {
        return instance;
    }

    protected GccLinker(String command, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix, boolean isLibtool, GccLinker libtoolLinker) {
        super(command, "-dumpversion", extensions, ignoredExtensions, outputPrefix, outputSuffix, isLibtool, libtoolLinker);
    }

    @Override
    protected void addImpliedArgs(CCTask task, boolean debug, LinkType linkType, Vector<String> args) {
        super.addImpliedArgs(task, debug, linkType, args);
        if (this.getIdentifier().contains("mingw")) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("-mconsole");
            }
            if (linkType.isSubsystemGUI()) {
                args.addElement("-mwindows");
            }
        }
    }

    @Override
    public String decorateLinkerOption(StringBuffer buf, String arg) {
        String decoratedArg = arg;
        if (arg.length() > 1 && arg.charAt(0) == '-') {
            switch (arg.charAt(1)) {
                case 'F': 
                case 'L': 
                case 'O': 
                case 'W': 
                case 'f': 
                case 'g': 
                case 'l': 
                case 'm': 
                case 'u': 
                case 'v': {
                    break;
                }
                default: {
                    boolean known = false;
                    for (String linkerOption : linkerOptions) {
                        if (!linkerOption.equals(arg)) continue;
                        known = true;
                        break;
                    }
                    if (known) break;
                    buf.setLength(0);
                    buf.append("-Wl,");
                    buf.append(arg);
                    decoratedArg = buf.toString();
                }
            }
        }
        return decoratedArg;
    }

    @Override
    public File[] getLibraryPath() {
        if (this.libDirs == null) {
            int i;
            String[] libpath;
            StringBuffer buf = new StringBuffer("/lib/gcc-lib/");
            buf.append(GccProcessor.getMachine());
            buf.append('/');
            buf.append(GccProcessor.getVersion());
            String[] impliedLibPath = new String[]{buf.toString(), "/lib/w32api", "/lib"};
            String[] specs = GccProcessor.getSpecs();
            String[][] libpaths = GccProcessor.parseSpecs(specs, "*link:", new String[]{"%q"});
            if (libpaths[0].length > 0) {
                libpath = new String[libpaths[0].length + 3];
                for (i = 0; i < libpaths[0].length; ++i) {
                    libpath[i] = libpaths[0][i];
                }
                libpath[i++] = buf.toString();
                libpath[i++] = "/lib/w32api";
                libpath[i++] = "/lib";
            } else {
                libpath = new String[]{"/usr/local/lib/mingw", "/usr/local/lib", "/usr/lib/w32api", "/usr/lib/mingw", "/usr/lib", buf.toString(), "/lib/w32api", "/lib"};
            }
            for (i = 0; i < libpath.length; ++i) {
                if (!libpath[i].contains("mingw")) continue;
                libpath[i] = null;
            }
            if (GccProcessor.isCygwin()) {
                GccProcessor.convertCygwinFilenames(libpath);
            }
            int count = CUtil.checkDirectoryArray(libpath);
            this.libDirs = new File[count];
            int index = 0;
            for (String element : libpath) {
                if (element == null) continue;
                this.libDirs[index++] = new File(element);
            }
        }
        return this.libDirs;
    }

    @Override
    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            return GccLibrarian.getInstance();
        }
        if (type.isJNIModule()) {
            return this.isDarwin() ? machJNILinker : (this.isWindows() ? dllLinker : soLinker);
        }
        if (type.isPluginModule()) {
            return this.isDarwin() ? machBundleLinker : (this.isWindows() ? dllLinker : soLinker);
        }
        if (type.isSharedLibrary()) {
            return this.isDarwin() ? machDllLinker : (this.isWindows() ? dllLinker : soLinker);
        }
        return instance;
    }
}

