/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.gcc.cross;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.CompilerParam;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.compiler.ProgressMonitor;
import com.github.maven_nar.cpptasks.gcc.GccCompatibleCCompiler;
import com.github.maven_nar.cpptasks.gcc.cross.GccLinker;
import com.github.maven_nar.cpptasks.gcc.cross.GccProcessor;
import com.github.maven_nar.cpptasks.parser.CParser;
import com.github.maven_nar.cpptasks.parser.FortranParser;
import com.github.maven_nar.cpptasks.parser.Parser;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public final class GccCCompiler
extends GccCompatibleCCompiler {
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cpp", ".cxx", ".c++", ".i", ".ii", ".f", ".for", ".f90", ".m", ".mm", ".s"};
    private static final GccCCompiler cppInstance = new GccCCompiler("c++", sourceExtensions, headerExtensions, false, new GccCCompiler("c++", sourceExtensions, headerExtensions, true, null, false, null), false, null);
    private static final GccCCompiler g77Instance = new GccCCompiler("g77", sourceExtensions, headerExtensions, false, new GccCCompiler("g77", sourceExtensions, headerExtensions, true, null, false, null), false, null);
    private static final GccCCompiler gppInstance = new GccCCompiler("g++", sourceExtensions, headerExtensions, false, new GccCCompiler("g++", sourceExtensions, headerExtensions, true, null, false, null), false, null);
    private static final GccCCompiler instance = new GccCCompiler("gcc", sourceExtensions, headerExtensions, false, new GccCCompiler("gcc", sourceExtensions, headerExtensions, true, null, false, null), false, null);
    private String identifier;
    private File[] includePath;
    private boolean isPICMeaningful = !System.getProperty("os.name").contains("Windows");

    public static GccCCompiler getCppInstance() {
        return cppInstance;
    }

    public static GccCCompiler getG77Instance() {
        return g77Instance;
    }

    public static GccCCompiler getGppInstance() {
        return gppInstance;
    }

    public static GccCCompiler getInstance() {
        return instance;
    }

    private GccCCompiler(String command, String[] sourceExtensions, String[] headerExtensions, boolean isLibtool, GccCCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(command, null, sourceExtensions, headerExtensions, isLibtool, libtoolCompiler, newEnvironment, env);
    }

    @Override
    public void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        super.addImpliedArgs(args, debug, multithreaded, exceptions, linkType, rtti, optimization);
        if (this.isPICMeaningful && linkType.isSharedLibrary()) {
            args.addElement("-fPIC");
        }
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new GccCCompiler(this.getCommand(), this.getSourceExtensions(), this.getHeaderExtensions(), this.getLibtool(), (GccCCompiler)this.getLibtoolCompiler(), newEnvironment, env);
        }
        return this;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        GccCCompiler clone = (GccCCompiler)super.clone();
        return clone;
    }

    @Override
    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) throws BuildException {
        try {
            GccCCompiler clone = (GccCCompiler)this.clone();
            CompilerParam param = config.getParam("target");
            if (param != null) {
                clone.setCommand(param.getValue() + "-" + this.getCommand());
            }
            clone.supercompile(task, outputDir, sourceFiles, args, endArgs, relentless, config, monitor);
        }
        catch (CloneNotSupportedException e) {
            this.supercompile(task, outputDir, sourceFiles, args, endArgs, relentless, config, monitor);
        }
    }

    @Override
    protected Parser createParser(File source) {
        char afterDot;
        String sourceName;
        int lastDot;
        if (source != null && (lastDot = (sourceName = source.getName()).lastIndexOf(46)) >= 0 && lastDot + 1 < sourceName.length() && ((afterDot = sourceName.charAt(lastDot + 1)) == 'f' || afterDot == 'F')) {
            return new FortranParser();
        }
        return new CParser();
    }

    @Override
    public File[] getEnvironmentIncludePath() {
        if (this.includePath == null) {
            String buf = "/lib/" + GccProcessor.getMachine() + '/' + GccProcessor.getVersion() + "/include";
            String[] defaultInclude = new String[]{buf};
            String[] specs = GccProcessor.getSpecs();
            String[][] optionValues = GccProcessor.parseSpecs(specs, "*cpp:", new String[]{"-isystem ", "-idirafter "});
            if (optionValues[0].length == 0 && optionValues[1].length == 0) {
                optionValues[0] = new String[]{"/usr/local/include", "/usr/include", "/usr/include/win32api"};
            }
            for (int i = 0; i < optionValues.length; ++i) {
                for (int j = 0; j < optionValues[i].length; ++j) {
                    if (optionValues[i][j].indexOf("mingw") <= 0) continue;
                    optionValues[i][j] = null;
                }
            }
            if (GccProcessor.isCygwin()) {
                GccProcessor.convertCygwinFilenames(optionValues[0]);
                GccProcessor.convertCygwinFilenames(optionValues[1]);
                GccProcessor.convertCygwinFilenames(defaultInclude);
            }
            int count = CUtil.checkDirectoryArray(optionValues[0]);
            count += CUtil.checkDirectoryArray(optionValues[1]);
            this.includePath = new File[count += CUtil.checkDirectoryArray(defaultInclude)];
            int index = 0;
            String[][] stringArray = optionValues;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray2;
                for (String anOptionValue : stringArray2 = stringArray[i]) {
                    if (anOptionValue == null) continue;
                    this.includePath[index++] = new File(anOptionValue);
                }
            }
            for (String[] stringArray3 : defaultInclude) {
                if (stringArray3 == null) continue;
                this.includePath[index++] = new File((String)stringArray3);
            }
        }
        return (File[])this.includePath.clone();
    }

    @Override
    public String getIdentifier() throws BuildException {
        if (this.identifier == null) {
            StringBuffer buf = this.getLibtool() ? new StringBuffer("libtool ") : new StringBuffer(" ");
            buf.append(this.getCommand());
            buf.append(' ');
            buf.append(GccProcessor.getVersion());
            buf.append(' ');
            buf.append(GccProcessor.getMachine());
            this.identifier = buf.toString();
        }
        return this.identifier;
    }

    @Override
    public Linker getLinker(LinkType linkType) {
        return GccLinker.getInstance().getLinker(linkType);
    }

    @Override
    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    private void supercompile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) throws BuildException {
        super.compile(task, outputDir, sourceFiles, args, endArgs, relentless, config, monitor);
    }
}

