/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.ide;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.TargetInfo;
import com.github.maven_nar.cpptasks.ide.CommentDef;
import com.github.maven_nar.cpptasks.ide.DependencyDef;
import com.github.maven_nar.cpptasks.ide.ProjectWriter;
import com.github.maven_nar.cpptasks.ide.ProjectWriterEnum;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;

public final class ProjectDef
extends DataType {
    private String ifProp;
    private String unlessProp;
    private File outFile;
    private String name;
    private boolean failOnError = true;
    private boolean overwrite = true;
    private ProjectWriter projectWriter;
    private File objDir;
    private final List<DependencyDef> dependencies = new ArrayList<DependencyDef>();
    private final List<CommentDef> comments = new ArrayList<CommentDef>();

    public void addComment(CommentDef comment) {
        this.comments.add(comment);
    }

    public void addDependency(DependencyDef dependency) {
        this.dependencies.add(dependency);
    }

    public void execute() {
        throw new BuildException("Not an actual task, but looks like one for documentation purposes");
    }

    public void execute(CCTask task, List<File> sources, Map<String, TargetInfo> targets, TargetInfo linkTarget) {
        try {
            this.projectWriter.writeProject(this.outFile, task, this, sources, targets, linkTarget);
        }
        catch (BuildException ex) {
            if (this.failOnError) {
                throw ex;
            }
            task.log(ex.toString());
        }
        catch (Exception ex) {
            if (this.failOnError) {
                throw new BuildException((Throwable)ex);
            }
            task.log(ex.toString());
        }
    }

    public List<CommentDef> getComments() {
        return new ArrayList<CommentDef>(this.comments);
    }

    public List<DependencyDef> getDependencies() {
        return new ArrayList<DependencyDef>(this.dependencies);
    }

    public String getName() {
        return this.name;
    }

    public File getObjdir() {
        return this.objDir;
    }

    public void getObjdir(File oDir) {
        this.objDir = oDir;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public boolean isActive() {
        Project project = this.getProject();
        return CUtil.isActive(project, this.ifProp, this.unlessProp);
    }

    public void setClassname(String className) {
        Object proc = null;
        try {
            Class<?> implClass = ProjectDef.class.getClassLoader().loadClass(className);
            try {
                Method getInstance = implClass.getMethod("getInstance", new Class[0]);
                proc = getInstance.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                proc = implClass.newInstance();
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
        this.projectWriter = (ProjectWriter)proc;
    }

    public void setFailonerror(boolean value) {
        this.failOnError = value;
    }

    public void setIf(String propName) {
        this.ifProp = propName;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setOutfile(File outfile) {
        if (outfile == null || outfile.toString().length() > 0) {
            this.outFile = outfile;
        }
    }

    public void setOverwrite(boolean value) {
        this.overwrite = value;
    }

    public void setType(ProjectWriterEnum value) {
        this.projectWriter = value.getProjectWriter();
    }

    public void setUnless(String propName) {
        this.unlessProp = propName;
    }
}

