/*
 * #%L
 * Native ARchive plugin for Maven
 * %%
 * Copyright (C) 2002 - 2014 NAR Maven Plugin developers.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package com.github.maven_nar;

import java.util.ArrayList;
import java.util.List;

import org.apache.maven.plugins.annotations.Parameter;

public class ProcessLibraryCommand {

  /**
   * The executable to run
   */
  @Parameter
  private String executable;

  /**
   * The library type that this command is valid for
   */
  @Parameter
  private String libraryType;

  /**
   * Any additional arguments to pass into the executable
   */
  @Parameter
  private List<String> arguments;

  public List<String> getArguments() {
    return this.arguments;
  }

  public List<String> getCommandList() {
    final List<String> command = new ArrayList<>();
    command.add(this.executable);
    if (this.arguments != null) {
      command.addAll(this.arguments);
    }
    return command;
  }

  public String getExecutable() {
    return this.executable;
  }

  public String getType() {
    return this.libraryType;
  }

  public void setArguments(final List<String> arguments) {
    this.arguments = arguments;
  }

  public void setExecutable(final String executable) {
    this.executable = executable;
  }

  public void setType(final String type) {
    this.libraryType = type;
  }

}
