/*
 * #%L
 * Native ARchive plugin for Maven
 * %%
 * Copyright (C) 2002 - 2014 NAR Maven Plugin developers.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
// FREEHEP
package com.github.maven_nar.cpptasks.intel;

import org.apache.tools.ant.types.Environment;

import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.gcc.GccCompatibleCCompiler;

public final class IntelLinux64Compiler extends GccCompatibleCCompiler {
  private static final IntelLinux64Compiler instance = new IntelLinux64Compiler(false, new IntelLinux64Compiler(true,
      null, false, null), false, null);

  public static IntelLinux64Compiler getInstance() {
    return instance;
  }

  private IntelLinux64Compiler(final boolean isLibtool, final IntelLinux64Compiler libtoolCompiler,
      final boolean newEnvironment, final Environment env) {
    super("ecpc", "-V", isLibtool, libtoolCompiler, newEnvironment, env);
  }

  @Override
  public Processor changeEnvironment(final boolean newEnvironment, final Environment env) {
    if (newEnvironment || env != null) {
      return new IntelLinux64Compiler(getLibtool(), (IntelLinux64Compiler) this.getLibtoolCompiler(), newEnvironment,
          env);
    }
    return this;
  }

  @Override
  public Linker getLinker(final LinkType type) {
    return IntelLinux64Linker.getInstance().getLinker(type);
  }

  @Override
  public int getMaximumCommandLength() {
    return Integer.MAX_VALUE;
  }
}
