/*
 * #%L
 * Native ARchive plugin for Maven
 * %%
 * Copyright (C) 2002 - 2014 NAR Maven Plugin developers.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package com.github.maven_nar.cpptasks.parser;

public class PostE extends AbstractParserState {
  private final AbstractParserState bracket;
  private final AbstractParserState quote;

  public PostE(final CParser parser, final AbstractParserState bracket, final AbstractParserState quote) {
    super(parser);
    this.bracket = bracket;
    this.quote = quote;
  }

  @Override
  public AbstractParserState consume(final char ch) {
    switch (ch) {
      case ' ':
      case '\t':
        return this;
      case '<':
        return this.bracket;
      case '"':
        return this.quote;
      case '\n':
        return getParser().getNewLineState();
    }
    return null;
  }
}
