/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractNarMojo;
import com.github.maven_nar.AttachedNarArtifact;
import com.github.maven_nar.Executable;
import com.github.maven_nar.NarArtifact;
import com.github.maven_nar.NarInfo;
import com.github.maven_nar.NarLayout;
import com.github.maven_nar.NarManager;
import com.github.maven_nar.NarUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.graph.transformer.NoopDependencyGraphTransformer;

public abstract class AbstractDependencyMojo
extends AbstractNarMojo {
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Component(role=ArtifactResolver.class)
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    protected List remoteArtifactRepositories;
    @Parameter(property="excludeArtifactIds", defaultValue="")
    protected String excludeArtifactIds;
    @Parameter(property="includeArtifactIds", defaultValue="")
    protected String includeArtifactIds;
    @Parameter(property="excludeGroupIds", defaultValue="")
    protected String excludeGroupIds;
    @Parameter(property="includeGroupIds", defaultValue="")
    protected String includeGroupIds;
    protected DependencyNode rootNode;
    @Component(hint="default")
    protected DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}")
    private List<RemoteRepository> projectRepos;
    @Component(role=ArchiverManager.class)
    protected ArchiverManager archiverManager;

    protected org.eclipse.aether.graph.DependencyNode getVerboseDependencyTree() {
        CollectRequest collectReq = new CollectRequest();
        Artifact art = this.getMavenProject().getArtifact();
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.repoSession);
        session.setDependencyGraphTransformer((DependencyGraphTransformer)new NoopDependencyGraphTransformer());
        Dependency dep = new Dependency((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(art.getGroupId(), art.getArtifactId(), null, art.getVersion()), null);
        collectReq.setRoot(dep);
        collectReq.setRepositories(this.projectRepos);
        try {
            return this.repoSystem.collectDependencies((RepositorySystemSession)session, collectReq).getRoot();
        }
        catch (DependencyCollectionException exception) {
            this.getLog().warn((CharSequence)"Could not collect dependencies from repo system", (Throwable)exception);
            return null;
        }
    }

    protected String dependencyTreeOrderStr(boolean pushDepsToLowestOrder) throws MojoExecutionException {
        DependencyNode libTreeRootNode;
        String depLevelOrderStr = "";
        try {
            libTreeRootNode = this.getRootNodeDependecyTree();
        }
        catch (MojoExecutionException exception) {
            this.getLog().warn((CharSequence)"linker Nar Default DependencyLibOrder is not used");
            return depLevelOrderStr;
        }
        this.getLog().debug((CharSequence)"{");
        this.getLog().debug((CharSequence)"Dependency Lib Order to be used::");
        if (pushDepsToLowestOrder) {
            List<String> VerboseDepList;
            try {
                VerboseDepList = this.depLevelVerboseList(this.getVerboseDependencyTree());
            }
            catch (MojoExecutionException e) {
                this.getLog().warn((CharSequence)"Exception caught while getting verbose dependency list: ", (Throwable)e);
                throw e;
            }
            HashSet<String> ReducedDepSet = new HashSet<String>();
            for (int i = VerboseDepList.size() - 1; i >= 0; --i) {
                String depStr = VerboseDepList.get(i);
                if (!ReducedDepSet.add(depStr)) continue;
                this.getLog().debug((CharSequence)depStr);
                depLevelOrderStr = !depLevelOrderStr.isEmpty() ? depStr + "," + depLevelOrderStr : depStr;
            }
        } else {
            List<DependencyNode> NodeList = this.depLevelOrderList(libTreeRootNode);
            for (DependencyNode node : NodeList) {
                if (node == null) continue;
                String[] nodestring = node.toNodeString().split(":");
                String usestring = nodestring[0] + ":" + nodestring[1];
                this.getLog().debug((CharSequence)usestring);
                if (!depLevelOrderStr.isEmpty()) {
                    depLevelOrderStr = depLevelOrderStr + "," + usestring;
                    continue;
                }
                depLevelOrderStr = usestring;
            }
        }
        this.getLog().debug((CharSequence)"}");
        return depLevelOrderStr;
    }

    private List<DependencyNode> depLevelOrderList(DependencyNode rootNode) {
        LinkedList<DependencyNode> aggDepNodeList = new LinkedList<DependencyNode>();
        List<DependencyNode> nodeChildList = rootNode.getChildren();
        while (!nodeChildList.isEmpty()) {
            nodeChildList = this.levelTraverseTreeList(nodeChildList, aggDepNodeList);
        }
        return aggDepNodeList;
    }

    private List<DependencyNode> levelTraverseTreeList(List<DependencyNode> nodeList, List<DependencyNode> aggDepNodeList) {
        aggDepNodeList.addAll(nodeList);
        ArrayList<DependencyNode> NodeChildList = new ArrayList<DependencyNode>();
        for (DependencyNode node : nodeList) {
            if (node == null || node.getChildren() == null) continue;
            NodeChildList.addAll(node.getChildren());
        }
        return NodeChildList;
    }

    private List<String> depLevelVerboseList(org.eclipse.aether.graph.DependencyNode rootNode) throws MojoExecutionException {
        ArrayList<org.eclipse.aether.graph.DependencyNode> AggDepNodeList = new ArrayList<org.eclipse.aether.graph.DependencyNode>();
        List<org.eclipse.aether.graph.DependencyNode> NodeChildList = rootNode.getChildren();
        while (!NodeChildList.isEmpty()) {
            NodeChildList = this.levelTraverseVerboseTreeList(NodeChildList, AggDepNodeList, rootNode);
        }
        ArrayList<String> FullDepList = new ArrayList<String>();
        ListIterator it = AggDepNodeList.listIterator();
        while (it.hasNext()) {
            org.eclipse.aether.artifact.Artifact art = ((org.eclipse.aether.graph.DependencyNode)it.next()).getArtifact();
            FullDepList.add(art.getGroupId() + ":" + art.getArtifactId());
        }
        return FullDepList;
    }

    private List<org.eclipse.aether.graph.DependencyNode> levelTraverseVerboseTreeList(List<org.eclipse.aether.graph.DependencyNode> nodeList, List<org.eclipse.aether.graph.DependencyNode> aggDepNodeList, org.eclipse.aether.graph.DependencyNode rootNode) throws MojoExecutionException {
        aggDepNodeList.addAll(nodeList);
        ArrayList<org.eclipse.aether.graph.DependencyNode> NodeChildList = new ArrayList<org.eclipse.aether.graph.DependencyNode>();
        for (org.eclipse.aether.graph.DependencyNode node : nodeList) {
            if (this.nodeArtifactsMatch(rootNode, node)) {
                throw new MojoExecutionException("Circular dependency detected in project: " + this.getMavenProject().toString());
            }
            if (node == null || node.getChildren() == null) continue;
            NodeChildList.addAll(node.getChildren());
        }
        return NodeChildList;
    }

    private boolean nodeArtifactsMatch(org.eclipse.aether.graph.DependencyNode nodeA, org.eclipse.aether.graph.DependencyNode nodeB) {
        if (nodeA == null || nodeB == null) {
            return false;
        }
        return nodeA.getArtifact().getGroupId().equals(nodeB.getArtifact().getGroupId()) && nodeA.getArtifact().getArtifactId().equals(nodeB.getArtifact().getArtifactId());
    }

    private DependencyNode getRootNodeDependecyTree() throws MojoExecutionException {
        try {
            ArtifactFilter artifactFilter = null;
            this.rootNode = this.dependencyGraphBuilder.buildDependencyGraph(this.getMavenProject(), artifactFilter);
        }
        catch (DependencyGraphBuilderException exception) {
            throw new MojoExecutionException("Cannot build project dependency graph", (Exception)((Object)exception));
        }
        return this.rootNode;
    }

    public final void downloadAttachedNars(List<AttachedNarArtifact> dependencies) throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Download for NarDependencies {");
        for (AttachedNarArtifact attachedNarArtifact : dependencies) {
            this.getLog().debug((CharSequence)("  - " + (Object)((Object)attachedNarArtifact)));
        }
        this.getLog().debug((CharSequence)"}");
        for (AttachedNarArtifact attachedNarArtifact : dependencies) {
            try {
                this.getLog().debug((CharSequence)("Resolving " + (Object)((Object)attachedNarArtifact)));
                this.artifactResolver.resolve((Artifact)attachedNarArtifact, this.remoteArtifactRepositories, this.getLocalRepository());
            }
            catch (ArtifactNotFoundException e) {
                String message = "nar not found " + attachedNarArtifact.getId();
                throw new MojoExecutionException(message, (Exception)((Object)e));
            }
            catch (ArtifactResolutionException e) {
                String message = "nar cannot resolve " + attachedNarArtifact.getId();
                throw new MojoExecutionException(message, (Exception)((Object)e));
            }
        }
    }

    public final List<AttachedNarArtifact> getAllAttachedNarArtifacts(List<NarArtifact> narArtifacts, List<? extends Executable> libraries) throws MojoExecutionException, MojoFailureException {
        ArrayList<AttachedNarArtifact> artifactList = new ArrayList<AttachedNarArtifact>();
        for (NarArtifact dependency : narArtifacts) {
            if ("NAR".equalsIgnoreCase(this.getMavenProject().getPackaging())) {
                String[] bindings;
                for (String binding : bindings = this.getBindings(libraries, dependency)) {
                    artifactList.addAll(this.getAttachedNarArtifacts(dependency, this.getAOL(), binding));
                }
            } else {
                artifactList.addAll(this.getAttachedNarArtifacts(dependency, this.getAOL(), "executable"));
                artifactList.addAll(this.getAttachedNarArtifacts(dependency, this.getAOL(), "shared"));
                artifactList.addAll(this.getAttachedNarArtifacts(dependency, this.getAOL(), "jni"));
                artifactList.addAll(this.getAttachedNarArtifacts(dependency, this.getAOL(), "static"));
            }
            artifactList.addAll(this.getAttachedNarArtifacts(dependency, null, "noarch"));
        }
        return artifactList;
    }

    protected final ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }

    protected abstract ScopeFilter getArtifactScopeFilter();

    protected List<AttachedNarArtifact> getAttachedNarArtifacts(List<? extends Executable> libraries) throws MojoFailureException, MojoExecutionException {
        this.getLog().info((CharSequence)"Getting Nar dependencies");
        List<NarArtifact> narArtifacts = this.getNarArtifacts();
        List<AttachedNarArtifact> attachedNarArtifacts = this.getAllAttachedNarArtifacts(narArtifacts, libraries);
        return attachedNarArtifacts;
    }

    private List<AttachedNarArtifact> getAttachedNarArtifacts(NarArtifact dependency, AOL aol, String type) throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("GetNarDependencies for " + (Object)((Object)dependency) + ", aol: " + aol + ", type: " + type));
        ArrayList<AttachedNarArtifact> artifactList = new ArrayList<AttachedNarArtifact>();
        NarInfo narInfo = dependency.getNarInfo();
        String[] nars = narInfo.getAttachedNars(aol, type);
        if (nars != null) {
            for (String nar2 : nars) {
                this.getLog().debug((CharSequence)("    Checking: " + nar2));
                if (nar2.equals("")) continue;
                String[] nar = nar2.split(":", 5);
                if (nar.length >= 4) {
                    try {
                        String groupId = nar[0].trim();
                        String artifactId = nar[1].trim();
                        String ext = nar[2].trim();
                        String classifier = nar[3].trim();
                        AOL aolString = narInfo.getAOL(aol);
                        if (aolString != null) {
                            classifier = NarUtil.replace("${aol}", aolString.toString(), classifier);
                        }
                        String version = nar.length >= 5 ? nar[4].trim() : dependency.getBaseVersion();
                        artifactList.add(new AttachedNarArtifact(groupId, artifactId, version, dependency.getScope(), ext, classifier, dependency.isOptional(), dependency.getFile()));
                        continue;
                    }
                    catch (InvalidVersionSpecificationException e) {
                        throw new MojoExecutionException("Error while reading nar file for dependency " + (Object)((Object)dependency), (Exception)((Object)e));
                    }
                }
                this.getLog().warn((CharSequence)("nars property in " + dependency.getArtifactId() + " contains invalid field: '" + nar2));
            }
        }
        return artifactList;
    }

    protected String[] getBindings(List<? extends Executable> libraries, NarArtifact dependency) throws MojoFailureException, MojoExecutionException {
        HashSet<String> bindings = new HashSet<String>();
        if (libraries != null) {
            for (Executable executable : libraries) {
                Executable exec = executable;
                String binding = exec.getBinding(dependency);
                if (null == binding) continue;
                bindings.add(binding);
            }
        }
        if (bindings.isEmpty()) {
            bindings.add(dependency.getNarInfo().getBinding(this.getAOL(), "static"));
        }
        return bindings.toArray(new String[1]);
    }

    protected String getBinding(Executable exec, NarArtifact dependency) throws MojoFailureException, MojoExecutionException {
        String binding = exec.getBinding(dependency);
        if (binding == null) {
            binding = dependency.getNarInfo().getBinding(this.getAOL(), "static");
        }
        return binding;
    }

    protected final ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public final List<NarArtifact> getNarArtifacts() throws MojoExecutionException {
        LinkedList<NarArtifact> narDependencies = new LinkedList<NarArtifact>();
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(AbstractDependencyMojo.cleanToBeTokenizedString(this.includeGroupIds), AbstractDependencyMojo.cleanToBeTokenizedString(this.excludeGroupIds)));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(AbstractDependencyMojo.cleanToBeTokenizedString(this.includeArtifactIds), AbstractDependencyMojo.cleanToBeTokenizedString(this.excludeArtifactIds)));
        filter.addFilter((ArtifactsFilter)this.getArtifactScopeFilter());
        Set artifacts = this.getMavenProject().getArtifacts();
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        for (Object element : artifacts) {
            Artifact dependency = (Artifact)element;
            if (!"nar".equalsIgnoreCase(dependency.getType())) continue;
            this.getLog().debug((CharSequence)("Examining artifact for NarInfo: " + dependency));
            NarInfo narInfo = this.getNarInfo(dependency);
            if (narInfo == null) continue;
            this.getLog().debug((CharSequence)"    - added as NarDependency");
            narDependencies.add(new NarArtifact(dependency, narInfo));
        }
        this.getLog().debug((CharSequence)("Dependencies contained " + narDependencies.size() + " NAR artifacts."));
        return narDependencies;
    }

    public final NarInfo getNarInfo(Artifact dependency) throws MojoExecutionException {
        NarInfo narInfo;
        NarInfo info;
        JarFile jar;
        File file;
        block12: {
            ZipInputStream zipStream;
            block11: {
                NarInfo narInfo2;
                dependency.isSnapshot();
                if (dependency.getFile().isDirectory()) {
                    this.getLog().debug((CharSequence)("Dependency is not packaged: " + dependency.getFile()));
                    return new NarInfo(dependency.getGroupId(), dependency.getArtifactId(), dependency.getBaseVersion(), this.getLog(), dependency.getFile());
                }
                file = new File(this.getLocalRepository().getBasedir(), this.getLocalRepository().pathOf(dependency));
                if (!file.exists()) {
                    this.getLog().debug((CharSequence)("Dependency nar file does not exist: " + file));
                    return null;
                }
                zipStream = null;
                try {
                    zipStream = new ZipInputStream(new FileInputStream(file));
                    if (zipStream.getNextEntry() != null) break block11;
                    this.getLog().debug((CharSequence)("Skipping unreadable artifact: " + file));
                    narInfo2 = null;
                }
                catch (IOException e) {
                    try {
                        throw new MojoExecutionException("Error while testing for zip file " + file, (Exception)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(zipStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)zipStream);
                return narInfo2;
            }
            IOUtils.closeQuietly((InputStream)zipStream);
            jar = null;
            jar = new JarFile(file);
            info = new NarInfo(dependency.getGroupId(), dependency.getArtifactId(), dependency.getBaseVersion(), this.getLog());
            if (info.exists(jar)) break block12;
            this.getLog().debug((CharSequence)("Dependency nar file does not contain this artifact: " + file));
            NarInfo narInfo3 = null;
            IOUtils.closeQuietly((Closeable)jar);
            return narInfo3;
        }
        try {
            info.read(jar);
            narInfo = info;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error while reading " + file, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jar);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)jar);
        return narInfo;
    }

    protected final NarManager getNarManager() throws MojoFailureException, MojoExecutionException {
        return new NarManager(this.getLog(), this.getLocalRepository(), this.getMavenProject(), this.getArchitecture(), this.getOS(), this.getLinker());
    }

    protected final List getRemoteRepositories() {
        return this.remoteArtifactRepositories;
    }

    public final void unpackAttachedNars(List<AttachedNarArtifact> dependencies) throws MojoExecutionException, MojoFailureException {
        File unpackDir = this.getUnpackDirectory();
        this.getLog().info((CharSequence)String.format("Unpacking %1$d dependencies to %2$s", dependencies.size(), unpackDir));
        Iterator<AttachedNarArtifact> iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            AttachedNarArtifact element;
            AttachedNarArtifact dependency = element = iterator.next();
            File file = this.getNarManager().getNarFile((Artifact)dependency);
            this.getLog().debug((CharSequence)String.format("Unpack %1$s (%2$s) to %3$s", new Object[]{dependency, file, unpackDir}));
            NarLayout layout = this.getLayout();
            layout.unpackNar(unpackDir, this.archiverManager, file, this.getOS(), this.getLinker().getName(), this.getAOL());
        }
    }

    private static String cleanToBeTokenizedString(String str) {
        String ret = "";
        if (!StringUtils.isEmpty((String)str)) {
            ret = str.trim().replaceAll("[\\s]*,[\\s]*", ",");
        }
        return ret;
    }
}

