/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class AttachedNarArtifact
extends DefaultArtifact {
    public AttachedNarArtifact(Artifact parent, String type, String classifier) {
        super(parent.getGroupId(), parent.getArtifactId(), parent.getVersionRange(), parent.getScope(), type, classifier, null, parent.isOptional());
        this.setArtifactHandler(new Handler(classifier));
    }

    public AttachedNarArtifact(String groupId, String artifactId, String version, String scope, String type, String classifier, boolean optional, File file) throws InvalidVersionSpecificationException {
        super(groupId, artifactId, VersionRange.createFromVersionSpec((String)version), scope, type, classifier, null, optional);
        this.setArtifactHandler(new Handler(classifier));
        this.setFile(new File(file.getParentFile(), artifactId + "-" + VersionRange.createFromVersionSpec((String)version) + "-" + classifier + "." + type));
    }

    private class Handler
    implements ArtifactHandler {
        private final String classifier;

        Handler(String classifier) {
            this.classifier = classifier;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getDirectory() {
            return "nars";
        }

        public String getExtension() {
            return "nar";
        }

        public String getLanguage() {
            return "native";
        }

        public String getPackaging() {
            return "nar";
        }

        public boolean isAddedToClasspath() {
            return true;
        }

        public boolean isIncludesDependencies() {
            return false;
        }
    }
}

