/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.IncludePath;
import com.github.maven_nar.Msvc;
import com.github.maven_nar.NarProperties;
import com.github.maven_nar.NarUtil;
import com.github.maven_nar.Test;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.CompilerEnum;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.types.CompilerArgument;
import com.github.maven_nar.cpptasks.types.ConditionalFileSet;
import com.github.maven_nar.cpptasks.types.DefineArgument;
import com.github.maven_nar.cpptasks.types.DefineSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public abstract class Compiler {
    public static final String MAIN = "main";
    public static final String TEST = "test";
    @Parameter
    private String name;
    @Parameter
    private String prefix;
    @Parameter
    private String toolPath;
    @Parameter(defaultValue="${basedir}/src/main", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${basedir}/src/test", required=true)
    private File testSourceDirectory;
    @Parameter(required=true)
    private boolean gccFileAbsolutePath = false;
    @Parameter(required=true)
    private Set<String> includes = new HashSet<String>();
    @Parameter(required=true)
    private Set<String> excludes = new HashSet<String>();
    @Parameter(required=true)
    private Set<String> testIncludes = new HashSet<String>();
    @Parameter(required=true)
    private Set<String> testExcludes = new HashSet<String>();
    @Parameter(defaultValue="false", required=false)
    private boolean ccache = false;
    @Parameter(required=true)
    private boolean debug = false;
    @Parameter(defaultValue="true", required=true)
    private boolean exceptions = true;
    @Parameter(defaultValue="true", required=true)
    private boolean rtti = true;
    @Parameter(defaultValue="none", required=true)
    private String optimize = "none";
    @Parameter(required=true)
    private boolean multiThreaded = false;
    @Parameter
    private List<String> defines;
    @Parameter
    private String defineSet;
    @Parameter(required=true)
    private boolean clearDefaultDefines;
    @Parameter
    private List<String> undefines;
    @Parameter
    private String undefineSet;
    @Parameter
    private boolean clearDefaultUndefines;
    @Parameter
    private List<IncludePath> includePaths;
    @Parameter
    private List<IncludePath> testIncludePaths;
    @Parameter
    private List<String> systemIncludePaths;
    @Parameter
    private List<String> options;
    @Parameter
    private List<String> testOptions;
    @Parameter
    private String optionSet;
    @Parameter(required=true)
    private boolean clearDefaultOptions;
    @Parameter
    private String compileOrder;
    private AbstractCompileMojo mojo;

    protected Compiler() {
    }

    private String cleanDefineValue(String value) {
        return value.replaceAll("\r", "").replaceAll("\n", "");
    }

    public final void copyIncludeFiles(MavenProject mavenProject, File targetDirectory) throws IOException {
        for (IncludePath includePath : this.getIncludePaths("dummy")) {
            if (!includePath.exists()) continue;
            NarUtil.copyDirectoryStructure(includePath.getFile(), targetDirectory, includePath.getIncludes(), "**/*~,**/#*#,**/.#*,**/%*%,**/._*,**/CVS,**/CVS/**,**/.cvsignore,**/SCCS,**/SCCS/**,**/vssver.scc,**/.svn,**/.svn/**,**/.DS_Store");
        }
    }

    public final CompilerDef getCompiler(String type, String output) throws MojoFailureException, MojoExecutionException {
        Object us;
        String[] pair;
        DefineSet ds;
        String optionsProperty;
        String name = this.getName();
        if (name == null) {
            return null;
        }
        CompilerDef compilerDef = new CompilerDef();
        compilerDef.setProject(this.mojo.getAntProject());
        CompilerEnum compilerName = new CompilerEnum();
        compilerName.setValue(name);
        compilerDef.setName(compilerName);
        if (this.toolPath != null) {
            compilerDef.setToolPath(this.toolPath);
        } else if (Msvc.isMSVC(this.mojo)) {
            this.mojo.getMsvc().setToolPath(compilerDef, this.getLanguage());
        }
        compilerDef.setCompilerPrefix(this.prefix);
        compilerDef.setCcache(this.ccache);
        compilerDef.setDebug(this.debug);
        compilerDef.setExceptions(this.exceptions);
        compilerDef.setRtti(this.rtti);
        compilerDef.setMultithreaded(this.mojo.getOS().equals("Windows") || this.multiThreaded);
        OptimizationEnum optimization = new OptimizationEnum();
        optimization.setValue(this.optimize);
        compilerDef.setOptimize(optimization);
        if (this.options != null) {
            for (String string : this.options) {
                CompilerArgument arg = new CompilerArgument();
                arg.setValue(string);
                compilerDef.addConfiguredCompilerArg(arg);
            }
        }
        if (this.optionSet != null) {
            String[] opts;
            for (String opt : opts = this.optionSet.split("\\s")) {
                CompilerArgument arg = new CompilerArgument();
                arg.setValue(opt);
                compilerDef.addConfiguredCompilerArg(arg);
            }
        }
        compilerDef.setClearDefaultOptions(this.clearDefaultOptions);
        if (!this.clearDefaultOptions && (optionsProperty = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "options")) != null) {
            String[] stringArray;
            for (String element : stringArray = optionsProperty.split(" ")) {
                CompilerArgument arg = new CompilerArgument();
                arg.setValue(element);
                compilerDef.addConfiguredCompilerArg(arg);
            }
        }
        if (this.defines != null) {
            ds = new DefineSet();
            for (String string : this.defines) {
                DefineArgument define = new DefineArgument();
                String[] pair2 = string.split("=", 2);
                define.setName(pair2[0]);
                define.setValue(pair2.length > 1 ? this.cleanDefineValue(pair2[1]) : null);
                ds.addDefine(define);
            }
            compilerDef.addConfiguredDefineset(ds);
        }
        if (this.defineSet != null) {
            String[] defList = this.defineSet.split(",");
            DefineSet defineSet = new DefineSet();
            for (String element : defList) {
                pair = element.trim().split("=", 2);
                DefineArgument def = new DefineArgument();
                def.setName(pair[0]);
                def.setValue(pair.length > 1 ? this.cleanDefineValue(pair[1]) : null);
                defineSet.addDefine(def);
            }
            compilerDef.addConfiguredDefineset(defineSet);
        }
        if (!this.clearDefaultDefines) {
            ds = new DefineSet();
            String string = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "defines");
            if (string != null) {
                ds.setDefine(new CUtil.StringArrayBuilder(string));
            }
            compilerDef.addConfiguredDefineset(ds);
        }
        if (this.undefines != null) {
            us = new DefineSet();
            for (String string : this.undefines) {
                DefineArgument undefine = new DefineArgument();
                String[] pair3 = string.split("=", 2);
                undefine.setName(pair3[0]);
                undefine.setValue(pair3.length > 1 ? pair3[1] : null);
                ((DefineSet)((Object)us)).addUndefine(undefine);
            }
            compilerDef.addConfiguredDefineset((DefineSet)((Object)us));
        }
        if (this.undefineSet != null) {
            String[] undefList = this.undefineSet.split(",");
            DefineSet defineSet = new DefineSet();
            for (String element : undefList) {
                pair = element.trim().split("=", 2);
                DefineArgument undef = new DefineArgument();
                undef.setName(pair[0]);
                undef.setValue(pair.length > 1 ? pair[1] : null);
                defineSet.addUndefine(undef);
            }
            compilerDef.addConfiguredDefineset(defineSet);
        }
        if (!this.clearDefaultUndefines) {
            us = new DefineSet();
            String string = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "undefines");
            if (string != null) {
                ((DefineSet)((Object)us)).setUndefine(new CUtil.StringArrayBuilder(string));
            }
            compilerDef.addConfiguredDefineset((DefineSet)((Object)us));
        }
        for (IncludePath includePath : this.getIncludePaths(type)) {
            if (!includePath.exists()) {
                throw new MojoFailureException("NAR: Include path not found: " + includePath);
            }
            compilerDef.createIncludePath().setPath(includePath.getPath());
        }
        if (this.systemIncludePaths != null) {
            for (String string : this.systemIncludePaths) {
                compilerDef.createSysIncludePath().setPath(string);
            }
        }
        List<File> srcDirs = this.getSourceDirectories(type);
        Set<String> set = this.getIncludes(type);
        Set<String> excludeSet = this.getExcludes(type);
        for (Object o : this.mojo.getTests()) {
            Test test = (Test)o;
            if (test.getName().equals(output)) continue;
            excludeSet.add("**/" + test.getName() + ".*");
        }
        for (File srcDir : srcDirs) {
            this.mojo.getLog().debug((CharSequence)("Checking for existence of " + this.getLanguage() + " source directory: " + srcDir));
            if (!srcDir.exists()) continue;
            if (this.compileOrder != null) {
                compilerDef.setOrder(Arrays.asList(StringUtils.split((String)this.compileOrder, (String)", ")));
            }
            ConditionalFileSet fileSet = new ConditionalFileSet();
            fileSet.setProject(this.mojo.getAntProject());
            fileSet.setIncludes(StringUtils.join(set.iterator(), (String)","));
            fileSet.setExcludes(StringUtils.join(excludeSet.iterator(), (String)","));
            fileSet.setDir(srcDir);
            compilerDef.addFileset(fileSet);
        }
        if (type.equals(TEST)) {
            if (this.testSourceDirectory.exists()) {
                compilerDef.setWorkDir(this.testSourceDirectory);
            }
        } else if (this.sourceDirectory.exists()) {
            compilerDef.setWorkDir(this.sourceDirectory);
        }
        compilerDef.setGccFileAbsolutePath(this.gccFileAbsolutePath);
        return compilerDef;
    }

    public final Set<String> getExcludes() throws MojoFailureException, MojoExecutionException {
        return this.getExcludes(MAIN);
    }

    protected final Set<String> getExcludes(String type) throws MojoFailureException, MojoExecutionException {
        HashSet<String> result = new HashSet<String>();
        if (type.equals(TEST) && !this.testExcludes.isEmpty()) {
            result.addAll(this.testExcludes);
        } else if (!this.excludes.isEmpty()) {
            result.addAll(this.excludes);
        } else {
            String defaultExcludes = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "excludes");
            if (defaultExcludes != null) {
                String[] exclude;
                for (String element : exclude = defaultExcludes.split(" ")) {
                    result.add(element.trim());
                }
            }
        }
        return result;
    }

    protected final List<IncludePath> getIncludePaths(String type) {
        List<IncludePath> includeList;
        List<IncludePath> list = includeList = type.equals(TEST) ? this.testIncludePaths : this.includePaths;
        if (includeList != null && includeList.size() != 0) {
            return includeList;
        }
        includeList = new ArrayList<IncludePath>();
        for (File file2 : this.getSourceDirectories(type)) {
            File file = new File(file2, "include");
            if (!file.isDirectory()) continue;
            IncludePath includePath = new IncludePath();
            includePath.setPath(file.getPath());
            includeList.add(includePath);
        }
        return includeList;
    }

    public final Set<String> getIncludes() throws MojoFailureException, MojoExecutionException {
        return this.getIncludes(MAIN);
    }

    protected final Set<String> getIncludes(String type) throws MojoFailureException, MojoExecutionException {
        HashSet<String> result = new HashSet<String>();
        if (!type.equals(TEST) && !this.includes.isEmpty()) {
            result.addAll(this.includes);
        } else if (type.equals(TEST) && !this.testIncludes.isEmpty()) {
            result.addAll(this.testIncludes);
        } else {
            String defaultIncludes = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "includes");
            if (defaultIncludes != null) {
                String[] include;
                for (String element : include = defaultIncludes.split(" ")) {
                    result.add(element.trim());
                }
            }
        }
        return result;
    }

    protected abstract String getLanguage();

    public String getName() throws MojoFailureException, MojoExecutionException {
        if (this.name == null) {
            this.name = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "compiler");
        }
        if (this.prefix == null) {
            this.prefix = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "prefix");
        }
        return this.name;
    }

    protected final String getPrefix() throws MojoFailureException, MojoExecutionException {
        return this.mojo.getAOL().getKey() + "." + this.getLanguage() + ".";
    }

    public final List<File> getSourceDirectories() {
        return this.getSourceDirectories("dummy");
    }

    private List<File> getSourceDirectories(String type) {
        ArrayList<File> sourceDirectories = new ArrayList<File>();
        File baseDir = this.mojo.getMavenProject().getBasedir();
        if (type.equals(TEST)) {
            if (this.testSourceDirectory == null) {
                this.testSourceDirectory = new File(baseDir, "/src/test");
            }
            if (this.testSourceDirectory.exists()) {
                sourceDirectories.add(this.testSourceDirectory);
            }
            for (Object element : this.mojo.getMavenProject().getTestCompileSourceRoots()) {
                File extraTestSourceDirectory = new File((String)element);
                if (!extraTestSourceDirectory.exists()) continue;
                sourceDirectories.add(extraTestSourceDirectory);
            }
        } else {
            if (this.sourceDirectory == null) {
                this.sourceDirectory = new File(baseDir, "src/main");
            }
            if (this.sourceDirectory.exists()) {
                sourceDirectories.add(this.sourceDirectory);
            }
            for (Object element : this.mojo.getMavenProject().getCompileSourceRoots()) {
                File extraSourceDirectory = new File((String)element);
                if (!extraSourceDirectory.exists()) continue;
                sourceDirectories.add(extraSourceDirectory);
            }
        }
        if (this.mojo.getLog().isDebugEnabled()) {
            for (File file : sourceDirectories) {
                this.mojo.getLog().debug((CharSequence)("Added to sourceDirectory: " + file.getPath()));
            }
        }
        return sourceDirectories;
    }

    public final CompilerDef getTestCompiler(String type, String output) throws MojoFailureException, MojoExecutionException {
        CompilerDef compiler = this.getCompiler(type, output);
        if (compiler != null && this.testOptions != null) {
            for (String string : this.testOptions) {
                CompilerArgument arg = new CompilerArgument();
                arg.setValue(string);
                compiler.addConfiguredCompilerArg(arg);
            }
        }
        return compiler;
    }

    public final void setAbstractCompileMojo(AbstractCompileMojo mojo) {
        this.mojo = mojo;
    }

    public String toString() {
        return NarUtil.prettyMavenString(this);
    }
}

