/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractDependencyMojo;
import com.github.maven_nar.NarArtifact;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.LinkerDef;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.Project;

public class Lib {
    @Parameter(required=true)
    private String name;
    @Parameter(defaultValue="shared", required=true)
    private String type = "shared";
    @Parameter(required=true)
    private File directory;
    @Parameter
    private List libs;

    public final void addLibSet(AbstractDependencyMojo mojo, LinkerDef linker, Project antProject) throws MojoFailureException, MojoExecutionException {
        if (this.name == null) {
            throw new MojoFailureException("NAR: Please specify <Name> as part of <Lib> for library \"" + this.name + "\"");
        }
        this.addLibSet(mojo, linker, antProject, this.name, this.directory);
    }

    private void addLibSet(AbstractDependencyMojo mojo, LinkerDef linker, Project antProject, String name, File dir) throws MojoFailureException, MojoExecutionException {
        if (this.libs == null) {
            this.addSingleLibSet(linker, antProject, name, dir);
        } else {
            this.addMultipleLibSets(mojo, linker, antProject, name);
        }
    }

    private void addMultipleLibSets(AbstractDependencyMojo mojo, LinkerDef linker, Project antProject, String name) throws MojoFailureException, MojoExecutionException {
        List<NarArtifact> dependencies = mojo.getNarArtifacts();
        for (Object lib1 : this.libs) {
            Lib lib = (Lib)lib1;
            String[] ids = name.split(":", 2);
            if (ids.length != 2) {
                throw new MojoFailureException("NAR: Please specify <Name> as part of <Lib> in format 'groupId:artifactId'");
            }
            for (NarArtifact dependency1 : dependencies) {
                Artifact dependency = (Artifact)dependency1;
                if (!dependency.getGroupId().equals(ids[0]) || !dependency.getArtifactId().equals(ids[1])) continue;
                File narDir = new File(dependency.getFile().getParentFile(), "nar/lib/" + mojo.getAOL() + "/" + lib.type);
                String narName = dependency.getArtifactId() + "-" + lib.name + "-" + dependency.getBaseVersion();
                lib.addLibSet(mojo, linker, antProject, narName, narDir);
            }
        }
    }

    private void addSingleLibSet(LinkerDef linker, Project antProject, String name, File dir) throws MojoFailureException, MojoExecutionException {
        if (!this.type.equals("framework") && dir == null) {
            throw new MojoFailureException("NAR: Please specify <Directory> as part of <Lib> for library \"" + name + "\"");
        }
        LibrarySet libSet = new LibrarySet();
        libSet.setProject(antProject);
        libSet.setLibs(new CUtil.StringArrayBuilder(name));
        LibraryTypeEnum libType = new LibraryTypeEnum();
        libType.setValue(this.type);
        libSet.setType(libType);
        libSet.setDir(dir);
        linker.addLibset(libSet);
    }
}

