/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.Compiler;
import com.github.maven_nar.Library;
import com.github.maven_nar.NARVersionInfo;
import com.github.maven_nar.NarArtifact;
import com.github.maven_nar.NarUtil;
import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.LinkerDef;
import com.github.maven_nar.cpptasks.OutputTypeEnum;
import com.github.maven_nar.cpptasks.RuntimeType;
import com.github.maven_nar.cpptasks.SubsystemEnum;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LinkerArgument;
import com.github.maven_nar.cpptasks.types.SystemLibrarySet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="nar-compile", defaultPhase=LifecyclePhase.COMPILE, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class NarCompileMojo
extends AbstractCompileMojo {
    @Parameter(property="nar.embedManifest", defaultValue="true")
    protected boolean embedManifest = true;
    @Component
    protected MavenSession session;

    private void copyInclude(Compiler c) throws IOException, MojoExecutionException, MojoFailureException {
        if (c == null) {
            return;
        }
        c.copyIncludeFiles(this.getMavenProject(), this.getLayout().getIncludeDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion()));
    }

    private void createLibrary(Project antProject, Library library) throws MojoExecutionException, MojoFailureException {
        File jniDirectory;
        VersionInfo versionInfo;
        NARVersionInfo narVersioninfo;
        CompilerDef fortran;
        CompilerDef c;
        CompilerDef cpp;
        CompilerDef res;
        CompilerDef mc;
        CompilerDef idl;
        this.getLog().debug((CharSequence)("Creating Library " + library));
        CCTask task = new CCTask();
        task.setCommandLogLevel(this.commandLogLevel);
        task.setProject(antProject);
        task.setDecorateLinkerOptions(this.decorateLinkerOptions);
        SubsystemEnum subSystem = new SubsystemEnum();
        subSystem.setValue(library.getSubSystem());
        task.setSubsystem(subSystem);
        task.setMaxCores(this.getMaxCores(this.getAOL()));
        OutputTypeEnum outTypeEnum = new OutputTypeEnum();
        String type = library.getType();
        outTypeEnum.setValue(type);
        task.setOuttype(outTypeEnum);
        task.setLinkCPP(library.linkCPP());
        task.setLinkFortran(library.linkFortran());
        task.setLinkFortranMain(library.linkFortranMain());
        File outDir = type.equals("executable") ? this.getLayout().getBinDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), this.getAOL().toString()) : this.getLayout().getLibDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), this.getAOL().toString(), type);
        outDir.mkdirs();
        File outFile = new File(outDir, this.getOutput(this.getAOL(), type));
        this.getLog().debug((CharSequence)("NAR - output: '" + outFile + "'"));
        task.setOutfile(outFile);
        File objDir = new File(this.getTargetDirectory(), "obj");
        objDir = new File(objDir, this.getAOL().toString());
        objDir.mkdirs();
        task.setObjdir(objDir);
        task.setFailonerror(this.failOnError(this.getAOL()));
        task.setLibtool(this.useLibtool(this.getAOL()));
        RuntimeType runtimeType = new RuntimeType();
        runtimeType.setValue(this.getRuntime(this.getAOL()));
        task.setRuntime(runtimeType);
        if (this.getIdl() != null && (idl = this.getIdl().getCompiler("main", null)) != null) {
            task.addConfiguredCompiler(idl);
            task.createIncludePath().setPath(objDir.getPath());
        }
        if (this.getMessage() != null && (mc = this.getMessage().getCompiler("main", null)) != null) {
            task.addConfiguredCompiler(mc);
            task.createIncludePath().setPath(objDir.getPath());
        }
        if (this.getResource() != null && (res = this.getResource().getCompiler("main", null)) != null) {
            task.addConfiguredCompiler(res);
        }
        if (this.getCpp() != null && (cpp = this.getCpp().getCompiler("main", null)) != null) {
            cpp.setFortifyID(this.getfortifyID());
            task.addConfiguredCompiler(cpp);
        }
        if (this.getC() != null && (c = this.getC().getCompiler("main", null)) != null) {
            c.setFortifyID(this.getfortifyID());
            task.addConfiguredCompiler(c);
        }
        if (this.getFortran() != null && (fortran = this.getFortran().getCompiler("main", null)) != null) {
            task.addConfiguredCompiler(fortran);
        }
        if (this.getOS().equals("Windows") && this.getLinker().getName(null, null).equals("msvc") && (narVersioninfo = this.getNARVersionInfo()) != null && (versionInfo = narVersioninfo.getVersionInfo(this.getAntProject())) != null) {
            task.addConfiguredVersioninfo(versionInfo);
        }
        if ((jniDirectory = this.getJavah().getJniDirectory()).exists()) {
            task.createIncludePath().setPath(jniDirectory.getPath());
        }
        this.getJava().addIncludePaths(task, type);
        this.getMsvc().configureCCTask(task);
        List<NarArtifact> dependencies = this.getNarArtifacts();
        Iterator<NarArtifact> iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            NarArtifact element;
            NarArtifact narDependency = element = iterator.next();
            String binding = this.getBinding(library, narDependency);
            this.getLog().debug((CharSequence)("Looking for " + (Object)((Object)narDependency) + " found binding " + binding));
            if (binding.equals("jni")) continue;
            File unpackDirectory = this.getUnpackDirectory();
            File include = this.getLayout().getIncludeDirectory(unpackDirectory, narDependency.getArtifactId(), narDependency.getBaseVersion());
            this.getLog().debug((CharSequence)("Looking for include directory: " + include));
            if (include.exists()) {
                task.createIncludePath().setPath(include.getPath());
                continue;
            }
            this.getLog().warn((CharSequence)String.format("Unable to locate %1$s lib include path '%2$s'", binding, include));
        }
        LinkerDef linkerDefinition = this.getLinker().getLinker(this, task, this.getOS(), this.getAOL().getKey() + ".linker.", type);
        task.addConfiguredLinker(linkerDefinition);
        boolean skipDepLink = linkerDefinition.isSkipDepLink();
        if ((type.equals("shared") || type.equals("jni") || type.equals("executable")) && !skipDepLink) {
            Object tmp;
            List depLibOrder = this.getDependencyLibOrder();
            Object depLibs = dependencies;
            if (depLibOrder != null && !depLibOrder.isEmpty()) {
                tmp = new LinkedList();
                for (Object aDepLibOrder : depLibOrder) {
                    String depToOrderName = (String)aDepLibOrder;
                    Iterator j = depLibs.iterator();
                    while (j.hasNext()) {
                        NarArtifact dep = (NarArtifact)((Object)j.next());
                        String depName = dep.getGroupId() + ":" + dep.getArtifactId();
                        if (!depName.equals(depToOrderName)) continue;
                        tmp.add(dep);
                        j.remove();
                    }
                }
                tmp.addAll(depLibs);
                depLibs = tmp;
            }
            tmp = depLibs.iterator();
            while (tmp.hasNext()) {
                String sysLibs;
                Object depLib = tmp.next();
                NarArtifact dependency = (NarArtifact)((Object)depLib);
                String binding = dependency.getNarInfo().getBinding(this.getAOL(), "none");
                this.getLog().debug((CharSequence)("Using Binding: " + binding));
                AOL aol = this.getAOL();
                aol = dependency.getNarInfo().getAOL(this.getAOL());
                this.getLog().debug((CharSequence)("Using Library AOL: " + aol.toString()));
                if (binding.equals("jni") || binding.equals("none") || binding.equals("executable")) continue;
                File unpackDirectory = this.getUnpackDirectory();
                File dir = this.getLayout().getLibDirectory(unpackDirectory, dependency.getArtifactId(), dependency.getBaseVersion(), aol.toString(), binding);
                this.getLog().debug((CharSequence)("Looking for Library Directory: " + dir));
                if (dir.exists()) {
                    LibrarySet libSet = new LibrarySet();
                    libSet.setProject(antProject);
                    String libs = dependency.getNarInfo().getLibs(this.getAOL());
                    if (libs != null && !libs.equals("")) {
                        this.getLog().debug((CharSequence)("Using LIBS = " + libs));
                        libSet.setLibs(new CUtil.StringArrayBuilder(libs));
                        libSet.setDir(dir);
                        task.addLibset(libSet);
                    }
                } else {
                    this.getLog().debug((CharSequence)("Library Directory " + dir + " does NOT exist."));
                }
                String options = dependency.getNarInfo().getOptions(this.getAOL());
                if (options != null && !options.equals("")) {
                    this.getLog().debug((CharSequence)("Using OPTIONS = " + options));
                    LinkerArgument arg = new LinkerArgument();
                    arg.setValue(options);
                    linkerDefinition.addConfiguredLinkerArg(arg);
                }
                if ((sysLibs = dependency.getNarInfo().getSysLibs(this.getAOL())) == null || sysLibs.equals("")) continue;
                this.getLog().debug((CharSequence)("Using SYSLIBS = " + sysLibs));
                SystemLibrarySet sysLibSet = new SystemLibrarySet();
                sysLibSet.setProject(antProject);
                sysLibSet.setLibs(new CUtil.StringArrayBuilder(sysLibs));
                task.addSyslibset(sysLibSet);
            }
        }
        this.getJava().addRuntime(task, this.getJavaHome(this.getAOL()), this.getOS(), this.getAOL().getKey() + ".java.");
        try {
            task.execute();
        }
        catch (BuildException e) {
            throw new MojoExecutionException("NAR: Compile failed", (Exception)((Object)e));
        }
        if ((this.isEmbedManifest() || this.getLinker().isGenerateManifest()) && this.getOS().equals("Windows") && this.getLinker().getName().equals("msvc") && !this.getLinker().getVersion(this).startsWith("6.")) {
            String[] env = new String[]{"PATH=" + this.getMsvc().getPathVariable().getValue()};
            String libType = library.getType();
            if ("jni".equals(libType) || "shared".equals(libType) || "executable".equals(libType)) {
                Vector<String> commandlineArgs = new Vector<String>();
                commandlineArgs.add("/manifest");
                this.getManifests(outFile.getPath(), commandlineArgs);
                if (commandlineArgs.size() == 1) {
                    if (this.isEmbedManifest()) {
                        this.getLog().warn((CharSequence)"Embed manifest requested, no source manifests to embed, no manifest generated");
                    }
                } else {
                    File mtexeFile;
                    if ("jni".equals(libType) || "shared".equals(libType)) {
                        String dll = outFile.getPath() + ".dll";
                        if (this.isEmbedManifest()) {
                            commandlineArgs.add("/outputresource:" + dll + ";#2");
                        } else {
                            commandlineArgs.add("/out:" + dll + ".manifest");
                        }
                    } else {
                        String exe = outFile.getPath() + ".exe";
                        if (this.isEmbedManifest()) {
                            commandlineArgs.add("/outputresource:" + exe + ";#1");
                        } else {
                            commandlineArgs.add("/out:" + exe + ".manifest");
                        }
                    }
                    String[] commandlineArgsArray = commandlineArgs.toArray(new String[0]);
                    String mtexe = "mt.exe";
                    if (this.getMsvc().compareVersion(this.getMsvc().getWindowsSdkVersion(), "7.0") < 0 && this.getLinker().getVersion(this).startsWith("8.")) {
                        mtexeFile = new File(this.getMsvc().getToolPath(), mtexe);
                        if (mtexeFile.exists()) {
                            mtexe = mtexeFile.getAbsolutePath();
                        }
                    } else {
                        mtexeFile = new File(this.getMsvc().getSDKToolPath(), mtexe);
                        if (mtexeFile.exists()) {
                            mtexe = mtexeFile.getAbsolutePath();
                        }
                    }
                    int result = NarUtil.runCommand(mtexe, commandlineArgsArray, null, null, this.getLog());
                    if (result != 0) {
                        throw new MojoFailureException("MT.EXE failed with exit code: " + result);
                    }
                }
            }
        }
        if (this.getOS().equals("Windows") && "static".equals(library.getType())) {
            this.getLog().debug((CharSequence)("Copy static pdbs from intermediat dir to " + task.getOutfile().getParentFile()));
            try {
                NarUtil.copyDirectoryStructure(task.getObjdir(), task.getOutfile().getParentFile(), "**/*.pdb", "**/*~,**/#*#,**/.#*,**/%*%,**/._*,**/CVS,**/CVS/**,**/.cvsignore,**/SCCS,**/SCCS/**,**/vssver.scc,**/.svn,**/.svn/**,**/.DS_Store");
            }
            catch (IOException e) {
                this.getLog().info((CharSequence)("Failed to copy pdbs from " + task.getObjdir() + "\nexception" + e.getMessage()));
            }
        }
    }

    @Override
    protected ScopeFilter getArtifactScopeFilter() {
        return new ScopeFilter("compile", null);
    }

    private List getSourcesFor(Compiler compiler) throws MojoFailureException, MojoExecutionException {
        if (compiler == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList files = new ArrayList();
            List<File> srcDirs = compiler.getSourceDirectories();
            for (File srcDir : srcDirs) {
                File dir = srcDir;
                if (!dir.exists()) continue;
                files.addAll(FileUtils.getFiles((File)dir, (String)StringUtils.join(compiler.getIncludes().iterator(), (String)","), null));
            }
            return files;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        this.getTargetDirectory().mkdirs();
        int noOfSources = 0;
        noOfSources += this.getSourcesFor(this.getCpp()).size();
        noOfSources += this.getSourcesFor(this.getC()).size();
        if ((noOfSources += this.getSourcesFor(this.getFortran()).size()) > 0) {
            this.getLog().info((CharSequence)("Compiling " + noOfSources + " native files"));
            for (Library library : this.getLibraries()) {
                this.createLibrary(this.getAntProject(), library);
            }
        } else {
            this.getLog().info((CharSequence)"Nothing to compile");
        }
        try {
            this.copyInclude(this.getCpp());
            this.copyInclude(this.getC());
            this.copyInclude(this.getFortran());
        }
        catch (IOException e) {
            throw new MojoExecutionException("NAR: could not copy include files", (Exception)e);
        }
        this.getNarInfo().writeToDirectory(this.classesDirectory);
    }

    public boolean isEmbedManifest() {
        return this.embedManifest;
    }

    private void getManifests(String generated, Vector<String> manifests) {
        if (this.getLinker().isGenerateManifest()) {
            manifests.add(generated + ".manifest");
        }
    }
}

