/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class NarInfo {
    public static final String NAR_PROPERTIES = "nar.properties";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Properties info;
    private final Log log;

    public NarInfo(String groupId, String artifactId, String version, Log log) throws MojoExecutionException {
        this(groupId, artifactId, version, log, null);
    }

    public NarInfo(String groupId, String artifactId, String version, Log log, File propertiesFile) throws MojoExecutionException {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.log = log;
        this.info = new Properties();
        if (propertiesFile != null) {
            try {
                if (propertiesFile.isDirectory()) {
                    propertiesFile = new File(propertiesFile, this.getNarInfoFileName());
                }
                this.info.load(new FileInputStream(propertiesFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem loading " + propertiesFile, (Exception)e);
            }
        }
    }

    public final void addNar(AOL aol, String type, String nar) {
        String nars = this.getProperty(aol, "nar." + type);
        nars = nars == null ? nar : nars + ", " + nar;
        this.setProperty(aol, "nar." + type, nars);
    }

    public final boolean exists(JarFile jar) {
        return this.getNarPropertiesEntry(jar) != null;
    }

    public final AOL getAOL(AOL aol) {
        return aol == null ? null : new AOL(this.getProperty(aol, aol.toString(), aol.toString()));
    }

    public final String[] getAttachedNars(AOL aol, String type) {
        String attachedNars = this.getProperty(aol, "nar." + type);
        return attachedNars != null ? attachedNars.split(",") : null;
    }

    public final String getBinding(AOL aol, String defaultBinding) {
        return this.getProperty(aol, "libs.binding", defaultBinding);
    }

    public final String getExactProperty(AOL aol, String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        String value = this.info.getProperty((aol == null ? "" : aol.toString() + ".") + key, defaultValue);
        this.log.debug((CharSequence)("getExactProperty(" + aol + ", " + key + ", " + defaultValue + ") = " + value));
        return value;
    }

    public final String getLibs(AOL aol) {
        return this.getProperty(aol, "libs.names", this.getOutput(aol, this.artifactId + "-" + this.version));
    }

    public String getNarInfoFileName() {
        return "META-INF/nar/" + this.groupId + "/" + this.artifactId + "/" + NAR_PROPERTIES;
    }

    private JarEntry getNarPropertiesEntry(JarFile jar) {
        return jar.getJarEntry(this.getNarInfoFileName());
    }

    public final String getOptions(AOL aol) {
        return this.getProperty(aol, "linker.options");
    }

    public final String getOutput(AOL aol, String defaultOutput) {
        return this.getExactProperty(aol, "output", defaultOutput);
    }

    public final String getProperty(AOL aol, String key) {
        return this.getProperty(aol, key, (String)null);
    }

    public final boolean getProperty(AOL aol, String key, boolean defaultValue) {
        return Boolean.valueOf(this.getProperty(aol, key, String.valueOf(defaultValue)));
    }

    public final File getProperty(AOL aol, String key, File defaultValue) {
        return new File(this.getProperty(aol, key, defaultValue.getPath()));
    }

    public final int getProperty(AOL aol, String key, int defaultValue) {
        return Integer.parseInt(this.getProperty(aol, key, Integer.toString(defaultValue)));
    }

    public final String getProperty(AOL aol, String key, String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        String value = this.info.getProperty(key, defaultValue);
        value = aol == null ? value : this.info.getProperty(aol.toString() + "." + key, value);
        this.log.debug((CharSequence)("getProperty(" + aol + ", " + key + ", " + defaultValue + ") = " + value));
        return value;
    }

    public final String getSysLibs(AOL aol) {
        return this.getProperty(aol, "syslibs.names");
    }

    public final void read(JarFile jar) throws IOException {
        this.info.load(jar.getInputStream(this.getNarPropertiesEntry(jar)));
    }

    public final void setBinding(AOL aol, String value) {
        this.setProperty(aol, "libs.binding", value);
    }

    public final void setNar(AOL aol, String type, String nar) {
        this.setProperty(aol, "nar." + type, nar);
    }

    public final void setOutput(AOL aol, String value) {
        this.setProperty(aol, "output", value);
    }

    public final void setLibs(AOL aol, String value) {
        this.setProperty(aol, "libs.names", value);
    }

    private void setProperty(AOL aol, String key, String value) {
        if (aol == null) {
            this.info.setProperty(key, value);
        } else {
            this.info.setProperty(aol.toString() + "." + key, value);
        }
    }

    public final String toString() {
        StringBuffer s = new StringBuffer("NarInfo for ");
        s.append(this.groupId);
        s.append(":");
        s.append(this.artifactId);
        s.append("-");
        s.append(this.version);
        s.append(" {\n");
        for (Object element : this.info.keySet()) {
            String key = (String)element;
            s.append("   ");
            s.append(key);
            s.append("='");
            s.append(this.info.getProperty(key, "<null>"));
            s.append("'\n");
        }
        s.append("}\n");
        return s.toString();
    }

    public final void writeToDirectory(File directory) throws MojoExecutionException {
        try {
            this.writeToFile(new File(directory, this.getNarInfoFileName()));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Cannot write nar properties file to " + directory, (Exception)ioe);
        }
    }

    public final void writeToFile(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        this.info.store(new FileOutputStream(file), "NAR Properties for " + this.groupId + "." + this.artifactId + "-" + this.version);
    }
}

