/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractNarLayout;
import com.github.maven_nar.AbstractNarMojo;
import com.github.maven_nar.NarFileLayout;
import com.github.maven_nar.NarFileLayout10;
import com.github.maven_nar.NarInfo;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.FileUtils;

public class NarLayout21
extends AbstractNarLayout {
    private final NarFileLayout fileLayout = new NarFileLayout10();

    public NarLayout21(Log log) {
        super(log);
    }

    @Override
    public final void attachNars(File baseDir, ArchiverManager archiverManager, MavenProjectHelper projectHelper, MavenProject project) throws MojoExecutionException {
        if (this.getNoArchDirectory(baseDir, project.getArtifactId(), project.getVersion()).exists()) {
            this.attachNar(archiverManager, projectHelper, project, "noarch", this.getNoArchDirectory(baseDir, project.getArtifactId(), project.getVersion()), "*/**");
        }
        String[] subDirs = baseDir.list();
        for (int i = 0; subDirs != null && i < subDirs.length; ++i) {
            String classifier;
            String artifactIdVersion = project.getArtifactId() + "-" + project.getVersion();
            if (!subDirs[i].startsWith(artifactIdVersion) || (classifier = subDirs[i].substring(artifactIdVersion.length() + 1)).equals("noarch")) continue;
            File dir = new File(baseDir, subDirs[i]);
            this.attachNar(archiverManager, projectHelper, project, classifier, dir, "*/**");
        }
    }

    private File getAolDirectory(File baseDir, String artifactId, String version, String aol, String type) {
        return new File(baseDir, artifactId + "-" + version + "-" + aol + "-" + type);
    }

    @Override
    public final File getBinDirectory(File baseDir, String artifactId, String version, String aol) {
        File dir = this.getAolDirectory(baseDir, artifactId, version, aol, "executable");
        dir = new File(dir, this.fileLayout.getBinDirectory(aol));
        return dir;
    }

    @Override
    public final File getIncludeDirectory(File baseDir, String artifactId, String version) {
        return new File(this.getNoArchDirectory(baseDir, artifactId, version), this.fileLayout.getIncludeDirectory());
    }

    @Override
    public final File getLibDirectory(File baseDir, String artifactId, String version, String aol, String type) throws MojoExecutionException {
        if (type.equals("executable")) {
            throw new MojoExecutionException("NAR: for type EXECUTABLE call getBinDirectory instead of getLibDirectory");
        }
        File dir = this.getAolDirectory(baseDir, artifactId, version, aol, type);
        dir = new File(dir, this.fileLayout.getLibDirectory(aol, type));
        return dir;
    }

    @Override
    public File getNarUnpackDirectory(File baseUnpackDirectory, File narFile) {
        File dir = new File(baseUnpackDirectory, FileUtils.basename((String)narFile.getPath(), (String)".nar"));
        return dir;
    }

    @Override
    public File getNoArchDirectory(File baseDir, String artifactId, String version) {
        return new File(baseDir, artifactId + "-" + version + "-" + "noarch");
    }

    @Override
    public final void prepareNarInfo(File baseDir, MavenProject project, NarInfo narInfo, AbstractNarMojo mojo) throws MojoExecutionException {
        if (this.getNoArchDirectory(baseDir, project.getArtifactId(), project.getVersion()).exists()) {
            narInfo.setNar(null, "noarch", project.getGroupId() + ":" + project.getArtifactId() + ":" + "nar" + ":" + "noarch");
        }
        String artifactIdVersion = project.getArtifactId() + "-" + project.getVersion();
        String[] subDirs = baseDir.list();
        ArrayList<String> classifiers = new ArrayList<String>();
        for (int i = 0; subDirs != null && i < subDirs.length; ++i) {
            String classifier;
            if (!subDirs[i].startsWith(artifactIdVersion) || (classifier = subDirs[i].substring(artifactIdVersion.length() + 1)).equals("noarch")) continue;
            classifiers.add(classifier);
        }
        if (!classifiers.isEmpty()) {
            for (String classifier : classifiers) {
                int lastDash = classifier.lastIndexOf(45);
                String type = classifier.substring(lastDash + 1);
                AOL aol = new AOL(classifier.substring(0, lastDash));
                if (narInfo.getOutput(aol, null) == null) {
                    narInfo.setOutput(aol, mojo.getOutput(!"executable".equals(type)));
                }
                if (mojo.getLibsName() != null) {
                    narInfo.setLibs(aol, mojo.getLibsName());
                }
                if (type.equals("shared")) {
                    narInfo.setBinding(aol, type);
                    narInfo.setBinding(null, type);
                } else {
                    if (narInfo.getBinding(aol, null) == null) {
                        narInfo.setBinding(aol, type);
                    } else if (type.equals("static")) {
                        narInfo.setBinding(aol, type);
                        narInfo.setBinding(null, type);
                    }
                    if (narInfo.getBinding(null, null) == null) {
                        narInfo.setBinding(null, type);
                    }
                }
                narInfo.setNar(null, type, project.getGroupId() + ":" + project.getArtifactId() + ":" + "nar" + ":${aol}-" + type);
            }
            if (mojo != null && narInfo.getOutput(null, null) == null) {
                narInfo.setOutput(null, mojo.getOutput(true));
            }
        }
    }

    @Override
    public void unpackNar(File unpackDirectory, ArchiverManager archiverManager, File file, String os, String linkerName, AOL defaultAOL) throws MojoExecutionException, MojoFailureException {
        File dir = this.getNarUnpackDirectory(unpackDirectory, file);
        boolean process = false;
        if (!unpackDirectory.exists()) {
            unpackDirectory.mkdirs();
            process = true;
        } else if (!dir.exists()) {
            process = true;
        } else if (file.lastModified() > dir.lastModified()) {
            NarUtil.deleteDirectory(dir);
            process = true;
        } else if (dir.list().length == 0) {
            process = true;
        }
        if (process) {
            this.unpackNarAndProcess(archiverManager, file, dir, os, linkerName, defaultAOL);
        }
    }
}

