/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.PropertyUtils;

public class NarProperties {
    private static final String AOL_PROPERTIES = "aol.properties";
    private static final String CUSTOM_AOL_PROPERTY_KEY = "nar.aolProperties";
    private static Map<MavenProject, NarProperties> instances = new HashMap<MavenProject, NarProperties>();
    private final Properties properties;

    public static NarProperties getInstance(MavenProject project) throws MojoFailureException {
        NarProperties instance = instances.get(project);
        if (instance == null) {
            if (project == null) {
                instance = new NarProperties(project, null, null);
            } else {
                String customPropertyLocation = project.getProperties().getProperty(CUSTOM_AOL_PROPERTY_KEY);
                if (customPropertyLocation == null) {
                    customPropertyLocation = System.getProperties().getProperty(CUSTOM_AOL_PROPERTY_KEY);
                }
                File narFile = customPropertyLocation != null ? new File(customPropertyLocation) : new File(project.getBasedir(), AOL_PROPERTIES);
                instance = narFile.exists() ? new NarProperties(project, narFile, customPropertyLocation) : NarProperties.getInstance(project.getParent());
            }
            instances.put(project, instance);
        }
        return instance;
    }

    public static void inject(MavenProject project, InputStream properties) throws MojoFailureException {
        Properties defaults = PropertyUtils.loadProperties((InputStream)properties);
        NarProperties nar = NarProperties.getInstance(project);
        nar.properties.putAll((Map<?, ?>)defaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NarProperties(MavenProject project, File narFile, String customPropertyLocation) throws MojoFailureException {
        Properties defaults = PropertyUtils.loadProperties((InputStream)NarUtil.class.getResourceAsStream(AOL_PROPERTIES));
        if (defaults == null) {
            throw new MojoFailureException("NAR: Could not load default properties file: 'aol.properties'.");
        }
        this.properties = new Properties(defaults);
        FileInputStream fis = null;
        try {
            if (project != null) {
                fis = new FileInputStream(narFile);
                this.properties.load(fis);
            }
        }
        catch (FileNotFoundException e) {
            if (customPropertyLocation != null) {
                throw new MojoFailureException("NAR: Could not load custom properties file: '" + customPropertyLocation + "'.");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Collection<String> getKnownAOLs() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Pattern pattern = Pattern.compile("([^.]+)\\.([^.]+)\\.([^.]+).*");
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            Matcher matcher;
            Object key = e.nextElement();
            if (!(key instanceof String) || !(matcher = pattern.matcher((String)key)).matches()) continue;
            result.add(matcher.group(1) + "-" + matcher.group(2) + "-" + matcher.group(3));
        }
        return result;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }
}

