/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.C;
import com.github.maven_nar.Cpp;
import com.github.maven_nar.Fortran;
import com.github.maven_nar.NarArtifact;
import com.github.maven_nar.Test;
import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.LinkerDef;
import com.github.maven_nar.cpptasks.OutputTypeEnum;
import com.github.maven_nar.cpptasks.RuntimeType;
import com.github.maven_nar.cpptasks.SubsystemEnum;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import com.github.maven_nar.cpptasks.types.LinkerArgument;
import com.github.maven_nar.cpptasks.types.SystemLibrarySet;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

@Mojo(name="nar-testCompile", defaultPhase=LifecyclePhase.TEST_COMPILE, requiresDependencyResolution=ResolutionScope.TEST)
public class NarTestCompileMojo
extends AbstractCompileMojo {
    @Parameter(property="skipNar")
    protected boolean skipNar;

    private void createTest(Project antProject, Test test) throws MojoExecutionException, MojoFailureException {
        Object tmp;
        List depLibOrder;
        CompilerDef fortranCompiler;
        Fortran fortran;
        CompilerDef cCompiler;
        C c;
        CompilerDef cppCompiler;
        String type = "test";
        CCTask task = new CCTask();
        task.setProject(antProject);
        SubsystemEnum subSystem = new SubsystemEnum();
        subSystem.setValue("console");
        task.setSubsystem(subSystem);
        OutputTypeEnum outTypeEnum = new OutputTypeEnum();
        outTypeEnum.setValue(test.getType());
        task.setOuttype(outTypeEnum);
        File outDir = new File(this.getTestTargetDirectory(), "bin");
        outDir = new File(outDir, this.getAOL().toString());
        outDir.mkdirs();
        File outFile = new File(outDir, test.getName());
        this.getLog().debug((CharSequence)("NAR - output: '" + outFile + "'"));
        task.setOutfile(outFile);
        File objDir = new File(this.getTestTargetDirectory(), "obj");
        objDir = new File(objDir, this.getAOL().toString());
        objDir.mkdirs();
        task.setObjdir(objDir);
        task.setFailonerror(this.failOnError(this.getAOL()));
        task.setLibtool(this.useLibtool(this.getAOL()));
        RuntimeType runtimeType = new RuntimeType();
        runtimeType.setValue(this.getRuntime(this.getAOL()));
        task.setRuntime(runtimeType);
        Cpp cpp = this.getCpp();
        if (cpp != null && (cppCompiler = this.getCpp().getTestCompiler("test", test.getName())) != null) {
            task.addConfiguredCompiler(cppCompiler);
        }
        if ((c = this.getC()) != null && (cCompiler = c.getTestCompiler("test", test.getName())) != null) {
            task.addConfiguredCompiler(cCompiler);
        }
        if ((fortran = this.getFortran()) != null && (fortranCompiler = this.getFortran().getTestCompiler("test", test.getName())) != null) {
            task.addConfiguredCompiler(fortranCompiler);
        }
        this.getJava().addIncludePaths(task, "test");
        this.getMsvc().configureCCTask(task);
        Object depLibs = this.getNarArtifacts();
        Iterator<NarArtifact> iterator = depLibs.iterator();
        while (iterator.hasNext()) {
            NarArtifact depLib1 = iterator.next();
            Artifact artifact = (Artifact)depLib1;
            File include = this.getLayout().getIncludeDirectory(this.getUnpackDirectory(), artifact.getArtifactId(), artifact.getBaseVersion());
            if (!include.exists()) {
                include = this.getLayout().getIncludeDirectory(this.getTestUnpackDirectory(), artifact.getArtifactId(), artifact.getBaseVersion());
            }
            if (!include.exists()) continue;
            task.createIncludePath().setPath(include.getPath());
        }
        File jniIncludeDir = this.getJavah().getJniDirectory();
        if (jniIncludeDir.exists()) {
            task.createIncludePath().setPath(jniIncludeDir.getPath());
        }
        LinkerDef linkerDefinition = this.getLinker().getTestLinker(this, task, this.getOS(), this.getAOL().getKey() + ".linker.", "test");
        task.addConfiguredLinker(linkerDefinition);
        File includeDir = this.getLayout().getIncludeDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion());
        String linkType = test.getLink(this.getLibraries());
        File libDir = this.getLayout().getLibDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), this.getAOL().toString(), linkType);
        if (includeDir.exists()) {
            task.createIncludePath().setLocation(includeDir);
        }
        if (libDir.exists()) {
            LibrarySet libSet = new LibrarySet();
            libSet.setProject(antProject);
            String libs = this.getNarInfo().getProperty(this.getAOL(), "libs.names", this.getOutput(true));
            this.getLog().debug((CharSequence)("Searching for parent to link with " + libs));
            libSet.setLibs(new CUtil.StringArrayBuilder(libs));
            Object libType = new LibraryTypeEnum();
            libType.setValue(linkType);
            libSet.setType((LibraryTypeEnum)((Object)libType));
            libSet.setDir(libDir);
            task.addLibset(libSet);
        }
        if ((depLibOrder = this.getDependencyLibOrder()) != null && !depLibOrder.isEmpty()) {
            tmp = new LinkedList();
            for (Object aDepLibOrder : depLibOrder) {
                String depToOrderName = (String)aDepLibOrder;
                Iterator j = depLibs.iterator();
                while (j.hasNext()) {
                    NarArtifact dep = (NarArtifact)((Object)j.next());
                    String depName = dep.getGroupId() + ":" + dep.getArtifactId();
                    if (!depName.equals(depToOrderName)) continue;
                    tmp.add(dep);
                    j.remove();
                }
            }
            tmp.addAll(depLibs);
            depLibs = tmp;
        }
        tmp = depLibs.iterator();
        while (tmp.hasNext()) {
            String sysLibs;
            Object depLib = tmp.next();
            NarArtifact dependency = (NarArtifact)((Object)depLib);
            String binding = this.getBinding(test, dependency);
            this.getLog().debug((CharSequence)("Using Binding: " + binding));
            AOL aol = this.getAOL();
            aol = dependency.getNarInfo().getAOL(this.getAOL());
            this.getLog().debug((CharSequence)("Using Library AOL: " + aol.toString()));
            if (binding.equals("jni") || binding.equals("none") || binding.equals("executable")) continue;
            File dir = this.getLayout().getLibDirectory(this.getUnpackDirectory(), dependency.getArtifactId(), dependency.getBaseVersion(), aol.toString(), binding);
            this.getLog().debug((CharSequence)("Looking for Library Directory: " + dir));
            if (!dir.exists()) {
                this.getLog().debug((CharSequence)("Library Directory " + dir + " does NOT exist."));
                dir = this.getLayout().getLibDirectory(this.getTestUnpackDirectory(), dependency.getArtifactId(), dependency.getBaseVersion(), aol.toString(), binding);
                this.getLog().debug((CharSequence)("Looking for Library Directory: " + dir));
            }
            if (dir.exists()) {
                LibrarySet libSet = new LibrarySet();
                libSet.setProject(antProject);
                String libs = dependency.getNarInfo().getLibs(this.getAOL());
                if (libs != null && !libs.equals("")) {
                    this.getLog().debug((CharSequence)("Using LIBS = " + libs));
                    libSet.setLibs(new CUtil.StringArrayBuilder(libs));
                    libSet.setDir(dir);
                    task.addLibset(libSet);
                }
            } else {
                this.getLog().debug((CharSequence)("Library Directory " + dir + " does NOT exist."));
            }
            String options = dependency.getNarInfo().getOptions(this.getAOL());
            if (options != null && !options.equals("")) {
                this.getLog().debug((CharSequence)("Using OPTIONS = " + options));
                LinkerArgument arg = new LinkerArgument();
                arg.setValue(options);
                linkerDefinition.addConfiguredLinkerArg(arg);
            }
            if ((sysLibs = dependency.getNarInfo().getSysLibs(this.getAOL())) == null || sysLibs.equals("")) continue;
            this.getLog().debug((CharSequence)("Using SYSLIBS = " + sysLibs));
            SystemLibrarySet sysLibSet = new SystemLibrarySet();
            sysLibSet.setProject(antProject);
            sysLibSet.setLibs(new CUtil.StringArrayBuilder(sysLibs));
            task.addSyslibset(sysLibSet);
        }
        this.getJava().addRuntime(task, this.getJavaHome(this.getAOL()), this.getOS(), this.getAOL().getKey() + ".java.");
        try {
            task.execute();
        }
        catch (BuildException e) {
            throw new MojoExecutionException("NAR: Test-Compile failed", (Exception)((Object)e));
        }
    }

    @Override
    protected ScopeFilter getArtifactScopeFilter() {
        return new ScopeFilter("test", null);
    }

    @Override
    protected File getUnpackDirectory() {
        return this.getTestUnpackDirectory() == null ? super.getUnpackDirectory() : this.getTestUnpackDirectory();
    }

    @Override
    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            this.getLog().info((CharSequence)"Not compiling test sources");
        } else {
            this.getTestTargetDirectory().mkdirs();
            for (Object o : this.getTests()) {
                this.createTest(this.getAntProject(), (Test)o);
            }
        }
    }
}

