/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks;

import com.github.maven_nar.cpptasks.FileVisitor;
import com.github.maven_nar.cpptasks.LinkerEnum;
import com.github.maven_nar.cpptasks.LinkerParam;
import com.github.maven_nar.cpptasks.ProcessorDef;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinker;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.gcc.GccLinker;
import com.github.maven_nar.cpptasks.types.FlexLong;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LinkerArgument;
import com.github.maven_nar.cpptasks.types.SystemLibrarySet;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FlexInteger;

public class LinkerDef
extends ProcessorDef {
    private long base = -1L;
    private String entry;
    private Boolean fixed;
    private Boolean incremental;
    private final Vector librarySets = new Vector();
    private Boolean map;
    private int stack = -1;
    private final Vector sysLibrarySets = new Vector();
    private String toolPath;
    private String linkerPrefix;
    private Boolean skipDepLink;
    private final Set<File> libraryDirectories = new LinkedHashSet<File>();

    private void addActiveLibrarySet(Project project, Vector libsets, Vector srcSets) {
        Enumeration srcenum = srcSets.elements();
        while (srcenum.hasMoreElements()) {
            LibrarySet set = (LibrarySet)((Object)srcenum.nextElement());
            if (!set.isActive(project)) continue;
            libsets.addElement(set);
        }
    }

    private void addActiveSystemLibrarySets(Project project, Vector libsets) {
        this.addActiveLibrarySet(project, libsets, this.sysLibrarySets);
    }

    private void addActiveUserLibrarySets(Project project, Vector libsets) {
        this.addActiveLibrarySet(project, libsets, this.librarySets);
    }

    public void addConfiguredLinkerArg(LinkerArgument arg) {
        this.addConfiguredProcessorArg(arg);
    }

    public void addConfiguredLinkerParam(LinkerParam param) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.addConfiguredProcessorParam(param);
    }

    public boolean addLibraryDirectory(File directory) {
        if (directory == null || !directory.exists()) {
            return false;
        }
        return this.libraryDirectories.add(directory);
    }

    public boolean addLibraryDirectory(File parent, String path) {
        if (parent == null) {
            return false;
        }
        File directory = new File(parent, path);
        return this.addLibraryDirectory(directory);
    }

    public void addLibraryDirectory(String path) {
        File directory = new File(path);
        this.addLibraryDirectory(directory);
    }

    public void addLibset(LibrarySet libset) {
        if (this.isReference()) {
            throw super.noChildrenAllowed();
        }
        if (libset == null) {
            throw new NullPointerException("libset");
        }
        this.librarySets.addElement(libset);
    }

    public void addSyslibset(SystemLibrarySet libset) {
        if (this.isReference()) {
            throw super.noChildrenAllowed();
        }
        if (libset == null) {
            throw new NullPointerException("libset");
        }
        this.sysLibrarySets.addElement(libset);
    }

    public void execute() throws BuildException {
        throw new BuildException("Not an actual task, but looks like one for documentation purposes");
    }

    public LibrarySet[] getActiveLibrarySets(LinkerDef[] defaultProviders, int index) {
        int i;
        if (this.isReference()) {
            return ((LinkerDef)((Object)this.getCheckedRef(LinkerDef.class, "LinkerDef"))).getActiveUserLibrarySets(defaultProviders, index);
        }
        Project p = this.getProject();
        Vector libsets = new Vector();
        for (i = index; i < defaultProviders.length; ++i) {
            defaultProviders[i].addActiveUserLibrarySets(p, libsets);
        }
        this.addActiveUserLibrarySets(p, libsets);
        for (i = index; i < defaultProviders.length; ++i) {
            defaultProviders[i].addActiveSystemLibrarySets(p, libsets);
        }
        this.addActiveSystemLibrarySets(p, libsets);
        LibrarySet[] sets = new LibrarySet[libsets.size()];
        libsets.copyInto((Object[])sets);
        return sets;
    }

    public LibrarySet[] getActiveSystemLibrarySets(LinkerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((LinkerDef)((Object)this.getCheckedRef(LinkerDef.class, "LinkerDef"))).getActiveUserLibrarySets(defaultProviders, index);
        }
        Project p = this.getProject();
        Vector libsets = new Vector();
        for (int i = index; i < defaultProviders.length; ++i) {
            defaultProviders[i].addActiveSystemLibrarySets(p, libsets);
        }
        this.addActiveSystemLibrarySets(p, libsets);
        LibrarySet[] sets = new LibrarySet[libsets.size()];
        libsets.copyInto((Object[])sets);
        return sets;
    }

    public LibrarySet[] getActiveUserLibrarySets(LinkerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((LinkerDef)((Object)this.getCheckedRef(LinkerDef.class, "LinkerDef"))).getActiveUserLibrarySets(defaultProviders, index);
        }
        Project p = this.getProject();
        Vector libsets = new Vector();
        for (int i = index; i < defaultProviders.length; ++i) {
            defaultProviders[i].addActiveUserLibrarySets(p, libsets);
        }
        this.addActiveUserLibrarySets(p, libsets);
        LibrarySet[] sets = new LibrarySet[libsets.size()];
        libsets.copyInto((Object[])sets);
        return sets;
    }

    public long getBase(LinkerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((LinkerDef)((Object)this.getCheckedRef(LinkerDef.class, "LinkerDef"))).getBase(defaultProviders, index);
        }
        if (this.base <= 0L && defaultProviders != null && index < defaultProviders.length) {
            return defaultProviders[index].getBase(defaultProviders, index + 1);
        }
        return this.base;
    }

    public String getEntry(LinkerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((LinkerDef)((Object)this.getCheckedRef(LinkerDef.class, "LinkerDef"))).getEntry(defaultProviders, index);
        }
        if (this.entry != null) {
            return this.entry;
        }
        if (defaultProviders != null && index < defaultProviders.length) {
            return defaultProviders[index].getEntry(defaultProviders, index + 1);
        }
        return null;
    }

    public Boolean getFixed(LinkerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((LinkerDef)((Object)this.getCheckedRef(LinkerDef.class, "LinkerDef"))).getFixed(defaultProviders, index);
        }
        if (this.fixed == null && defaultProviders != null && index < defaultProviders.length) {
            return defaultProviders[index].getFixed(defaultProviders, index + 1);
        }
        return this.fixed;
    }

    public boolean getIncremental(LinkerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((LinkerDef)((Object)this.getCheckedRef(LinkerDef.class, "LinkerDef"))).getIncremental(defaultProviders, index);
        }
        if (this.incremental != null) {
            return this.incremental;
        }
        if (defaultProviders != null && index < defaultProviders.length) {
            return defaultProviders[index].getIncremental(defaultProviders, index + 1);
        }
        return false;
    }

    public List<File> getLibraryDirectories() {
        return new ArrayList<File>(this.libraryDirectories);
    }

    public boolean getMap(LinkerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((LinkerDef)((Object)this.getCheckedRef(LinkerDef.class, "LinkerDef"))).getMap(defaultProviders, index);
        }
        if (this.map != null) {
            return this.map;
        }
        if (defaultProviders != null && index < defaultProviders.length) {
            return defaultProviders[index].getMap(defaultProviders, index + 1);
        }
        return false;
    }

    @Override
    public Processor getProcessor() {
        Linker linker = (Linker)super.getProcessor();
        if (linker == null) {
            linker = GccLinker.getInstance();
        }
        if (this.getLibtool() && linker instanceof CommandLineLinker) {
            CommandLineLinker cmdLineLinker = (CommandLineLinker)linker;
            linker = cmdLineLinker.getLibtoolLinker();
        }
        return linker;
    }

    @Override
    public Processor getProcessor(LinkType linkType) {
        Processor proc = this.getProcessor();
        return proc.getLinker(linkType);
    }

    public int getStack(LinkerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((LinkerDef)((Object)this.getCheckedRef(LinkerDef.class, "LinkerDef"))).getStack(defaultProviders, index);
        }
        if (this.stack < 0 && defaultProviders != null && index < defaultProviders.length) {
            return defaultProviders[index].getStack(defaultProviders, index + 1);
        }
        return this.stack;
    }

    public String getToolPath() {
        return this.toolPath;
    }

    public String getLinkerPrefix() {
        return this.linkerPrefix;
    }

    public boolean isSkipDepLink() {
        return this.skipDepLink;
    }

    public void setBase(FlexLong base) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.base = base.longValue();
    }

    public void setEntry(String entry) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.entry = entry;
    }

    public void setFixed(boolean fixed) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.fixed = LinkerDef.booleanValueOf(fixed);
    }

    public void setIncremental(boolean incremental) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.incremental = LinkerDef.booleanValueOf(incremental);
    }

    public void setMap(boolean map) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.map = LinkerDef.booleanValueOf(map);
    }

    public void setName(LinkerEnum name) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        Linker linker = name.getLinker();
        super.setProcessor(linker);
    }

    @Override
    protected void setProcessor(Processor proc) throws BuildException {
        Linker linker = null;
        if (proc instanceof Linker) {
            linker = (Linker)proc;
        } else {
            LinkType linkType = new LinkType();
            linker = proc.getLinker(linkType);
        }
        super.setProcessor(linker);
    }

    public void setStack(FlexInteger stack) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.stack = stack.intValue();
    }

    public void setToolPath(String path) {
        this.toolPath = path;
    }

    public void setLinkerPrefix(String prefix) {
        this.linkerPrefix = prefix;
    }

    public void setSkipDepLink(boolean skipDepLink) {
        this.skipDepLink = LinkerDef.booleanValueOf(skipDepLink);
    }

    public void visitSystemLibraries(Linker linker, FileVisitor libraryVisitor) {
        Project p = this.getProject();
        if (p == null) {
            throw new IllegalStateException("project must be set");
        }
        if (this.isReference()) {
            LinkerDef master = (LinkerDef)((Object)this.getCheckedRef(LinkerDef.class, "Linker"));
            master.visitSystemLibraries(linker, libraryVisitor);
        } else {
            LinkerDef extendsDef = (LinkerDef)this.getExtends();
            if (extendsDef != null) {
                extendsDef.visitSystemLibraries(linker, libraryVisitor);
            }
            if (this.sysLibrarySets.size() > 0) {
                File[] libpath = linker.getLibraryPath();
                for (int i = 0; i < this.sysLibrarySets.size(); ++i) {
                    LibrarySet set = (LibrarySet)((Object)this.sysLibrarySets.elementAt(i));
                    if (!set.isActive(p)) continue;
                    set.visitLibraries(p, linker, libpath, libraryVisitor);
                }
            }
        }
    }

    public void visitUserLibraries(Linker linker, FileVisitor libraryVisitor) {
        Project p = this.getProject();
        if (p == null) {
            throw new IllegalStateException("project must be set");
        }
        if (this.isReference()) {
            LinkerDef master = (LinkerDef)((Object)this.getCheckedRef(LinkerDef.class, "Linker"));
            master.visitUserLibraries(linker, libraryVisitor);
        } else {
            LinkerDef extendsDef = (LinkerDef)this.getExtends();
            if (extendsDef != null) {
                extendsDef.visitUserLibraries(linker, libraryVisitor);
            }
            if (this.librarySets.size() > 0) {
                File[] libpath = linker.getLibraryPath();
                for (int i = 0; i < this.librarySets.size(); ++i) {
                    LibrarySet set = (LibrarySet)((Object)this.librarySets.elementAt(i));
                    if (!set.isActive(p)) continue;
                    set.visitLibraries(p, linker, libpath, libraryVisitor);
                }
            }
        }
    }
}

