/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.FileVisitor;
import com.github.maven_nar.cpptasks.TargetInfo;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.LinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.ProcessorConfiguration;
import java.io.File;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;

public final class TargetMatcher
implements FileVisitor {
    private final LinkerConfiguration linker;
    private final Vector<File> objectFiles;
    private final File outputDir;
    private final ProcessorConfiguration[] processors;
    private final File[] sourceFiles = new File[1];
    private final Map<String, TargetInfo> targets;
    private final VersionInfo versionInfo;
    private final CCTask task;

    public TargetMatcher(CCTask task, File outputDir, ProcessorConfiguration[] processors, LinkerConfiguration linker, Vector<File> objectFiles, Map<String, TargetInfo> targets, VersionInfo versionInfo) {
        this.task = task;
        this.outputDir = outputDir;
        this.processors = processors;
        this.targets = targets;
        this.linker = linker;
        this.objectFiles = objectFiles;
        this.versionInfo = versionInfo;
    }

    @Override
    public void visit(File parentDir, String filename) throws BuildException {
        File fullPath = new File(parentDir, filename);
        ProcessorConfiguration selectedCompiler = null;
        int bid = 0;
        if (this.processors != null) {
            for (ProcessorConfiguration processor : this.processors) {
                int newBid = processor.bid(fullPath.toString());
                if (newBid <= bid) continue;
                bid = newBid;
                selectedCompiler = processor;
            }
        }
        if (bid <= 0) {
            int linkerbid;
            if (this.linker != null && (linkerbid = this.linker.bid(filename)) > 0) {
                this.objectFiles.addElement(fullPath);
                if (linkerbid == 1) {
                    this.task.log("Unrecognized file type " + fullPath.toString() + " will be passed to linker");
                }
            }
        } else {
            String[] outputFileNames = selectedCompiler.getOutputFileNames(fullPath.getPath(), this.versionInfo);
            this.sourceFiles[0] = fullPath;
            for (String outputFileName : outputFileNames) {
                TargetInfo previousTarget = this.targets.get(outputFileName);
                if (previousTarget == null) {
                    this.targets.put(outputFileName, new TargetInfo(selectedCompiler, this.sourceFiles, null, new File(this.outputDir, outputFileName), selectedCompiler.getRebuild()));
                    continue;
                }
                if (previousTarget.getSources()[0].equals(this.sourceFiles[0])) continue;
                String builder = "Output filename conflict: " + outputFileName + " would be produced from " + previousTarget.getSources()[0].toString() + " and " + filename;
                throw new BuildException(builder);
            }
        }
    }
}

