/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.borland;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.borland.BorlandLinker;
import com.github.maven_nar.cpptasks.borland.BorlandProcessor;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.compiler.ProgressMonitor;
import com.github.maven_nar.cpptasks.parser.CParser;
import com.github.maven_nar.cpptasks.parser.Parser;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public class BorlandResourceCompiler
extends CommandLineCompiler {
    private static final BorlandResourceCompiler instance = new BorlandResourceCompiler(false, null);

    public static BorlandResourceCompiler getInstance() {
        return instance;
    }

    private BorlandResourceCompiler(boolean newEnvironment, Environment env) {
        super("brc32", "c:\\__bogus\\__bogus.rc", new String[]{".rc"}, new String[]{".h", ".hpp", ".inl"}, ".res", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-r");
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int level) {
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new BorlandResourceCompiler(newEnvironment, env);
        }
        return this;
    }

    @Override
    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) throws BuildException {
        super.compile(task, outputDir, sourceFiles, args, endArgs, relentless, config, monitor);
    }

    @Override
    protected Parser createParser(File source) {
        return new CParser();
    }

    @Override
    protected int getArgumentCountPerInputFile() {
        return 2;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-d");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return BorlandProcessor.getEnvironmentPath("brc32", 'i', new String[]{"..\\include"});
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return BorlandProcessor.getIncludeDirSwitch("-i", includeDir);
    }

    @Override
    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (index == 0) {
            String[] outputFileNames = this.getOutputFileNames(filename, null);
            String fullOutputName = new File(outputDir, outputFileNames[0]).toString();
            return "-fo" + fullOutputName;
        }
        return filename;
    }

    @Override
    public Linker getLinker(LinkType type) {
        return BorlandLinker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }
}

