/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;

public class CaptureStreamHandler
implements ExecuteStreamHandler {
    private String[] stderr;
    private String[] stdout;
    private InputStream processErrorStream;
    private InputStream processOutputStream;

    public static CaptureStreamHandler execute(String[] cmdline) {
        CaptureStreamHandler handler = new CaptureStreamHandler();
        Execute exec = new Execute((ExecuteStreamHandler)handler);
        exec.setCommandline(cmdline);
        try {
            int n = exec.execute();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return handler;
    }

    public static String[] run(String[] cmdline) {
        CaptureStreamHandler handler = CaptureStreamHandler.execute(cmdline);
        return handler.getOutput() != null ? handler.getOutput() : new String[]{};
    }

    public void gatherOutput() {
        try {
            Copier errorCopier = new Copier(this.processErrorStream);
            Copier outputCopier = new Copier(this.processOutputStream);
            errorCopier.start();
            outputCopier.start();
            errorCopier.join();
            outputCopier.join();
            this.stderr = new String[errorCopier.getLines().size()];
            errorCopier.getLines().copyInto(this.stderr);
            this.stdout = new String[outputCopier.getLines().size()];
            outputCopier.getLines().copyInto(this.stdout);
        }
        catch (Exception e) {
            this.stdout = new String[0];
            this.stderr = this.stdout;
        }
    }

    public String[] getOutput() {
        return null != this.stderr && this.stderr.length > 0 ? this.stderr : this.stdout;
    }

    public String[] getStderr() {
        return this.stderr;
    }

    public String[] getStdout() {
        return this.stdout;
    }

    public void setProcessErrorStream(InputStream is) throws IOException {
        this.processErrorStream = is;
    }

    public void setProcessInputStream(OutputStream os) throws IOException {
        os.close();
    }

    public void setProcessOutputStream(InputStream is) throws IOException {
        this.processOutputStream = is;
    }

    public void start() throws IOException {
        this.gatherOutput();
    }

    public void stop() {
    }

    static class Copier
    extends Thread {
        InputStream is;
        Vector<String> lines;

        Copier(InputStream is) {
            this.is = is;
            this.lines = new Vector(10);
        }

        public Vector<String> getLines() {
            return this.lines;
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));
                while ((line = reader.readLine()) != null) {
                    this.lines.addElement(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

