/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.gcc;

import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.gcc.GccLinker;
import com.github.maven_nar.cpptasks.parser.CParser;
import com.github.maven_nar.cpptasks.parser.Parser;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.util.FileUtils;

public final class WindresResourceCompiler
extends CommandLineCompiler {
    private static final WindresResourceCompiler instance = new WindresResourceCompiler(false, null);

    public static WindresResourceCompiler getInstance() {
        return instance;
    }

    private WindresResourceCompiler(boolean newEnvironment, Environment env) {
        super("windres", null, new String[]{".rc"}, new String[]{".h", ".hpp", ".inl"}, ".o", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        if (debug) {
            args.addElement("-D_DEBUG");
        } else {
            args.addElement("-DNDEBUG");
        }
    }

    protected void addWarningSwitch(Vector args, int level) {
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new WindresResourceCompiler(newEnvironment, env);
        }
        return this;
    }

    @Override
    protected Parser createParser(File source) {
        return new CParser();
    }

    @Override
    protected int getArgumentCountPerInputFile() {
        return 2;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-D");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return new File[0];
    }

    @Override
    public String getIdentifier() {
        return "GNU windres";
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return "-I" + includeDir;
    }

    @Override
    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (index == 0) {
            String outputFileName = this.getOutputFileNames(filename, null)[0];
            String objectName = new File(outputDir, outputFileName).toString();
            return "-o" + objectName;
        }
        String relative = "";
        try {
            relative = FileUtils.getRelativePath((File)this.workDir, (File)new File(filename));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (relative.isEmpty()) {
            return filename;
        }
        return relative;
    }

    @Override
    public Linker getLinker(LinkType type) {
        return GccLinker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return Short.MAX_VALUE;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        buffer.append("-U");
        buffer.append(define);
    }
}

