/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.gcc.cross;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.compiler.CaptureStreamHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class GccProcessor {
    private static String machine;
    private static String[] specs;
    private static String version;

    private static int addLibraryPatterns(String[] libnames, StringBuffer buf, String prefix, String extension, String[] patterns, int offset) {
        for (int i = 0; i < libnames.length; ++i) {
            buf.setLength(0);
            buf.append(prefix);
            buf.append(libnames[i]);
            buf.append(extension);
            patterns[offset + i] = buf.toString();
        }
        return offset + libnames.length;
    }

    public static void convertCygwinFilenames(String[] names) {
        if (names == null) {
            throw new NullPointerException("names");
        }
        File gccDir = CUtil.getExecutableLocation("gcc.exe");
        if (gccDir != null) {
            String prefix = gccDir.getAbsolutePath() + "/..";
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                if (name == null || name.length() <= 1 || name.charAt(0) != '/') continue;
                buf.setLength(0);
                buf.append(prefix);
                buf.append(name);
                names[i] = buf.toString();
            }
        }
    }

    public static String getMachine() {
        if (machine == null) {
            String[] args = new String[]{"gcc", "-dumpmachine"};
            String[] cmdout = CaptureStreamHandler.run(args);
            machine = cmdout.length == 0 ? "nomachine" : cmdout[0];
        }
        return machine;
    }

    public static String[] getOutputFileSwitch(String letter, String outputFile) {
        StringBuffer buf = new StringBuffer();
        if (outputFile.indexOf(32) >= 0) {
            buf.append('\"');
            buf.append(outputFile.replace('\\', '/'));
            buf.append('\"');
        } else {
            buf.append(outputFile.replace('\\', '/'));
        }
        String[] retval = new String[]{letter, buf.toString()};
        return retval;
    }

    public static String[] getSpecs() {
        File gccParent;
        if (specs == null && (gccParent = CUtil.getExecutableLocation("gcc.exe")) != null) {
            String relativePath = "../lib/gcc-lib/" + GccProcessor.getMachine() + '/' + GccProcessor.getVersion() + "/specs";
            File specsFile = new File(gccParent, relativePath);
            try {
                BufferedReader reader = new BufferedReader(new FileReader(specsFile));
                Vector<String> lines = new Vector<String>(100);
                String line = reader.readLine();
                while (line != null) {
                    lines.addElement(line);
                    line = reader.readLine();
                }
                specs = new String[lines.size()];
                lines.copyInto(specs);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (specs == null) {
            specs = new String[0];
        }
        return specs;
    }

    public static String getVersion() {
        if (version == null) {
            String[] args = new String[]{"gcc", "-dumpversion"};
            String[] cmdout = CaptureStreamHandler.run(args);
            version = cmdout.length == 0 ? "noversion" : cmdout[0];
        }
        return version;
    }

    public static boolean isCaseSensitive() {
        return true;
    }

    public static boolean isCygwin() {
        return GccProcessor.getMachine().indexOf("cygwin") > 0;
    }

    private static boolean isHPUX() {
        String osname = System.getProperty("os.name").toLowerCase();
        return osname.contains("hp") && osname.contains("ux");
    }

    public static String[][] parseSpecs(String[] specsContent, String specSectionStart, String[] options) {
        int i;
        if (specsContent == null) {
            throw new NullPointerException("specsContent");
        }
        if (specSectionStart == null) {
            throw new NullPointerException("specSectionStart");
        }
        if (options == null) {
            throw new NullPointerException("option");
        }
        String[][] optionValues = new String[options.length][];
        StringBuffer optionValue = new StringBuffer(40);
        for (i = 0; i < specsContent.length; ++i) {
            int j;
            String specLine = specsContent[i];
            if (!specLine.startsWith(specSectionStart)) continue;
            Vector[] optionVectors = new Vector[options.length];
            for (j = 0; j < options.length; ++j) {
                optionVectors[j] = new Vector(10);
            }
            ++i;
            while (i < specsContent.length) {
                specLine = specsContent[i];
                for (j = 0; j < options.length; ++j) {
                    int optionStart = specLine.indexOf(options[j]);
                    while (optionStart >= 0) {
                        int k;
                        optionValue.setLength(0);
                        boolean hasNonBlank = false;
                        for (k = optionStart + options[j].length(); k < specLine.length(); ++k) {
                            if (specLine.charAt(k) == ' ' || specLine.charAt(k) == '}') {
                                if (!hasNonBlank) continue;
                                break;
                            }
                            hasNonBlank = true;
                            optionValue.append(specLine.charAt(k));
                        }
                        if (hasNonBlank) {
                            optionVectors[j].addElement(optionValue.toString());
                        }
                        optionStart = specLine.indexOf(options[j], k);
                    }
                }
                ++i;
            }
            for (j = 0; j < options.length; ++j) {
                optionValues[j] = new String[optionVectors[j].size()];
                optionVectors[j].copyInto(optionValues[j]);
            }
        }
        for (i = 0; i < optionValues.length; ++i) {
            String[] zeroLenArray = new String[]{};
            if (optionValues[i] != null) continue;
            optionValues[i] = zeroLenArray;
        }
        return optionValues;
    }

    private GccProcessor() {
    }
}

