/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.msvc;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.CompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.PrecompilingCommandLineCCompiler;
import com.github.maven_nar.cpptasks.msvc.MsvcProcessor;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.util.FileUtils;

public abstract class MsvcCompatibleCCompiler
extends PrecompilingCommandLineCCompiler {
    private static String[] mflags = new String[]{"/ML", "/MLd", null, null, "/MT", "/MTd", "/MD", "/MDd"};

    protected MsvcCompatibleCCompiler(String command, String identifierArg, boolean newEnvironment, Environment env) {
        super(command, identifierArg, new String[]{".c", ".cc", ".cpp", ".cxx", ".c++"}, new String[]{".h", ".hpp", ".inl"}, ".obj", false, null, newEnvironment, env);
    }

    protected void addDebugSwitch(Vector<String> args) {
        args.addElement("/Zi");
        args.addElement("/Od");
        args.addElement("/RTC1");
        args.addElement("/D_DEBUG");
    }

    protected void addPathSwitch(Vector<String> args) {
        args.addElement("/Fd" + this.objDir.getAbsolutePath() + File.separator);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        boolean staticRuntime;
        args.addElement("/c");
        args.addElement("/nologo");
        if (exceptions) {
            args.addElement("/EHsc");
        }
        int mindex = 0;
        if (multithreaded) {
            mindex += 4;
        }
        if (!(staticRuntime = linkType.isStaticRuntime())) {
            mindex += 2;
        }
        if (debug) {
            ++mindex;
            this.addDebugSwitch(args);
        } else {
            if (optimization != null) {
                if (optimization.isSize()) {
                    args.addElement("/O1");
                }
                if (optimization.isSpeed()) {
                    args.addElement("/O2");
                }
            }
            args.addElement("/DNDEBUG");
        }
        String mflag = mflags[mindex];
        if (mflag == null) {
            throw new BuildException("multithread='false' and runtime='dynamic' not supported");
        }
        args.addElement(mflag);
        if (rtti != null && rtti.booleanValue()) {
            args.addElement("/GR");
        } else {
            args.addElement("/GR-");
        }
        this.addPathSwitch(args);
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int level) {
        MsvcProcessor.addWarningSwitch(args, level);
    }

    @Override
    protected CompilerConfiguration createPrecompileGeneratingConfig(CommandLineCompilerConfiguration baseConfig, File prototype, String lastInclude) {
        String[] additionalArgs = new String[]{"/Fp" + CUtil.getBasename(prototype) + ".pch", "/Yc"};
        return new CommandLineCompilerConfiguration(baseConfig, additionalArgs, null, true);
    }

    @Override
    protected CompilerConfiguration createPrecompileUsingConfig(CommandLineCompilerConfiguration baseConfig, File prototype, String lastInclude, String[] exceptFiles) {
        String[] additionalArgs = new String[]{"/Fp" + CUtil.getBasename(prototype) + ".pch", "/Yu" + lastInclude};
        return new CommandLineCompilerConfiguration(baseConfig, additionalArgs, exceptFiles, false);
    }

    @Override
    protected int getArgumentCountPerInputFile() {
        return 2;
    }

    @Override
    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (index == 0) {
            String outputFileName = this.getOutputFileNames(filename, null)[0];
            String fullOutputName = new File(outputDir, outputFileName).toString();
            return "/Fo" + fullOutputName;
        }
        String relative = "";
        try {
            relative = FileUtils.getRelativePath((File)this.workDir, (File)new File(filename));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (relative.isEmpty()) {
            return filename;
        }
        return relative;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        MsvcProcessor.getDefineSwitch(buffer, define, value);
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ";");
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return MsvcProcessor.getIncludeDirSwitch(includeDir);
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        MsvcProcessor.getUndefineSwitch(buffer, define);
    }
}

