/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.sun;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinker;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.sun.C89Processor;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import java.io.File;
import java.util.Vector;

public final class C89Linker
extends CommandLineLinker {
    private static final C89Linker dllLinker = new C89Linker("lib", ".so");
    private static final C89Linker instance = new C89Linker("", "");
    private final String outputPrefix;

    public static C89Linker getInstance() {
        return instance;
    }

    private C89Linker(String outputPrefix, String outputSuffix) {
        super("ld", "/bogus", new String[]{".o", ".a", ".lib", ".x"}, new String[0], outputSuffix, false, null);
        this.outputPrefix = outputPrefix;
    }

    protected void addBase(long base, Vector<String> args) {
    }

    protected void addEntry(String entry, Vector<String> args) {
    }

    protected void addFixed(Boolean fixed, Vector<String> args) {
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector<String> args) {
        if (linkType.isSharedLibrary()) {
            args.addElement("-G");
        }
    }

    protected void addIncremental(boolean incremental, Vector<String> args) {
    }

    @Override
    public String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector<String> preargs, Vector<String> midargs, Vector<String> endargs) {
        super.addLibrarySets(task, libsets, preargs, midargs, endargs);
        StringBuffer buf = new StringBuffer("-l");
        for (LibrarySet set : libsets) {
            File libdir = set.getDir(null);
            String[] libs = set.getLibs();
            if (libdir != null) {
                endargs.addElement("-L");
                endargs.addElement(libdir.getAbsolutePath());
            }
            for (String lib : libs) {
                buf.setLength(2);
                buf.append(lib);
                endargs.addElement(buf.toString());
            }
        }
        return null;
    }

    protected void addMap(boolean map, Vector<String> args) {
    }

    protected void addStack(int stack, Vector<String> args) {
    }

    @Override
    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    @Override
    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    @Override
    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return C89Processor.getLibraryPatterns(libnames, libType);
    }

    @Override
    public Linker getLinker(LinkType linkType) {
        if (linkType.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    @Override
    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String[] getOutputFileNames(String baseName, VersionInfo versionInfo) {
        String[] baseNames = super.getOutputFileNames(baseName, versionInfo);
        if (this.outputPrefix.length() > 0) {
            for (int i = 0; i < baseNames.length; ++i) {
                baseNames[i] = this.outputPrefix + baseNames[i];
            }
        }
        return baseNames;
    }

    @Override
    public String[] getOutputFileSwitch(String outputFile) {
        return new String[]{"-o", outputFile};
    }

    @Override
    public boolean isCaseSensitive() {
        return C89Processor.isCaseSensitive();
    }
}

