/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.ti;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.CommandLineCCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.ti.ClxxLibrarian;
import com.github.maven_nar.cpptasks.ti.ClxxLinker;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public class ClxxCCompiler
extends CommandLineCCompiler {
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cpp", ".cxx", ".c++"};
    private static final ClxxCCompiler cl55 = new ClxxCCompiler("cl55", false, null);
    private static final ClxxCCompiler cl6x = new ClxxCCompiler("cl6x", false, null);

    public static ClxxCCompiler getCl55Instance() {
        return cl55;
    }

    public static ClxxCCompiler getCl6xInstance() {
        return cl6x;
    }

    private ClxxCCompiler(String command, boolean newEnvironment, Environment env) {
        super(command, "-h", sourceExtensions, headerExtensions, ".o", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        if (debug) {
            args.addElement("-gw");
        }
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int warnings) {
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-d");
        buffer.append(define);
        if (value != null) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        File[] c_dir = CUtil.getPathFromEnvironment("C_DIR", ";");
        File[] cx_dir = CUtil.getPathFromEnvironment("C6X_C_DIR", ";");
        if (c_dir.length == 0) {
            return cx_dir;
        }
        if (cx_dir.length == 0) {
            return c_dir;
        }
        File[] combo = new File[c_dir.length + cx_dir.length];
        System.arraycopy(cx_dir, 0, combo, 0, cx_dir.length);
        System.arraycopy(c_dir, 0, combo, 0 + cx_dir.length, c_dir.length);
        return combo;
    }

    @Override
    protected String getIncludeDirSwitch(String source) {
        return "-I" + source;
    }

    @Override
    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            if (this == cl6x) {
                return ClxxLibrarian.getCl6xInstance();
            }
            return ClxxLibrarian.getCl55Instance();
        }
        if (type.isSharedLibrary()) {
            if (this == cl6x) {
                return ClxxLinker.getCl6xDllInstance();
            }
            return ClxxLinker.getCl55DllInstance();
        }
        if (this == cl6x) {
            return ClxxLinker.getCl6xInstance();
        }
        return ClxxLinker.getCl55Instance();
    }

    @Override
    public int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        buffer.append("-u");
        buffer.append(define);
    }
}

