/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.types;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.FileVisitor;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class LibrarySet
extends DataType {
    private String dataset;
    private boolean explicitCaseSensitive;
    private String ifCond;
    private String[] libnames;
    private final FileSet set = new FileSet();
    private String unlessCond;
    private LibraryTypeEnum libraryType;

    public LibrarySet() {
        this.libnames = new String[0];
    }

    public void execute() throws BuildException {
        throw new BuildException("Not an actual task, but looks like one for documentation purposes");
    }

    public String getDataset() {
        if (this.isReference()) {
            LibrarySet master = (LibrarySet)((Object)this.getCheckedRef(LibrarySet.class, "LibrarySet"));
            return master.getDataset();
        }
        return this.dataset;
    }

    public File getDir(Project project) {
        if (this.isReference()) {
            LibrarySet master = (LibrarySet)((Object)this.getCheckedRef(LibrarySet.class, "LibrarySet"));
            return master.getDir(project);
        }
        return this.set.getDir(project);
    }

    protected FileSet getFileSet() {
        if (this.isReference()) {
            LibrarySet master = (LibrarySet)((Object)this.getCheckedRef(LibrarySet.class, "LibrarySet"));
            return master.getFileSet();
        }
        return this.set;
    }

    public String[] getLibs() {
        if (this.isReference()) {
            LibrarySet master = (LibrarySet)((Object)this.getCheckedRef(LibrarySet.class, "LibrarySet"));
            return master.getLibs();
        }
        String[] retval = (String[])this.libnames.clone();
        return retval;
    }

    public LibraryTypeEnum getType() {
        if (this.isReference()) {
            LibrarySet master = (LibrarySet)((Object)this.getCheckedRef(LibrarySet.class, "LibrarySet"));
            return master.getType();
        }
        return this.libraryType;
    }

    public boolean isActive(Project p) {
        String unlessValue;
        if (p == null) {
            throw new NullPointerException("p");
        }
        if (this.ifCond != null) {
            String ifValue = p.getProperty(this.ifCond);
            if (ifValue != null) {
                if (ifValue.equals("no") || ifValue.equals("false")) {
                    throw new BuildException("property " + this.ifCond + " used as if condition has value " + ifValue + " which suggests a misunderstanding of if attributes");
                }
            } else {
                return false;
            }
        }
        if (this.unlessCond != null && (unlessValue = p.getProperty(this.unlessCond)) != null) {
            if (unlessValue.equals("no") || unlessValue.equals("false")) {
                throw new BuildException("property " + this.unlessCond + " used as unless condition has value " + unlessValue + " which suggests a misunderstanding of unless attributes");
            }
            return false;
        }
        if (this.isReference()) {
            LibrarySet master = (LibrarySet)((Object)this.getCheckedRef(LibrarySet.class, "LibrarySet"));
            return master.isActive(this.project);
        }
        if (this.libnames.length == 0) {
            p.log("libnames not specified or empty.", 1);
            return false;
        }
        return true;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.explicitCaseSensitive = true;
        this.set.setCaseSensitive(isCaseSensitive);
    }

    public void setDataset(String dataset) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.dataset = dataset;
    }

    public void setDir(File dir) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.set.setDir(dir);
    }

    public void setIf(String propName) {
        this.ifCond = propName;
    }

    public void setLibs(CUtil.StringArrayBuilder libs) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.libnames = libs.getValue();
    }

    public void setProject(Project project) {
        this.set.setProject(project);
        super.setProject(project);
    }

    public void setType(LibraryTypeEnum type) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.libraryType = type;
    }

    public void setUnless(String propName) {
        this.unlessCond = propName;
    }

    public void visitLibraries(Project project, Linker linker, File[] libpath, FileVisitor visitor) throws BuildException {
        if (this.isReference()) {
            LibrarySet master = (LibrarySet)((Object)this.getCheckedRef(LibrarySet.class, "LibrarySet"));
            master.visitLibraries(project, linker, libpath, visitor);
        }
        if (this.libnames != null) {
            for (String libname : this.libnames) {
                String[] patterns = linker.getLibraryPatterns(new String[]{libname}, this.libraryType);
                if (patterns.length <= 0) continue;
                FileSet localSet = (FileSet)this.set.clone();
                if (!this.explicitCaseSensitive) {
                    boolean linkerCaseSensitive = linker.isCaseSensitive();
                    localSet.setCaseSensitive(linkerCaseSensitive);
                }
                for (String pattern : patterns) {
                    PatternSet.NameEntry entry = localSet.createInclude();
                    entry.setName(pattern);
                }
                int matches = 0;
                if (localSet.getDir(project) == null) {
                    for (int j = libpath.length - 1; j >= 0; --j) {
                        FileSet clone = (FileSet)localSet.clone();
                        clone.setDir(libpath[j]);
                        DirectoryScanner scanner = clone.getDirectoryScanner(project);
                        File basedir = scanner.getBasedir();
                        String[] files = scanner.getIncludedFiles();
                        matches += files.length;
                        for (String file : files) {
                            visitor.visit(basedir, file);
                        }
                    }
                } else {
                    DirectoryScanner scanner = localSet.getDirectoryScanner(project);
                    File basedir = scanner.getBasedir();
                    String[] files = scanner.getIncludedFiles();
                    matches += files.length;
                    for (String file : files) {
                        visitor.visit(basedir, file);
                    }
                }
                if (matches != 0) continue;
                StringBuffer msg = new StringBuffer("No file matching ");
                if (patterns.length == 1) {
                    msg.append("pattern (");
                    msg.append(patterns[0]);
                    msg.append(")");
                } else {
                    msg.append("patterns (\"");
                    msg.append(patterns[0]);
                    for (int k = 1; k < patterns.length; ++k) {
                        msg.append(", ");
                        msg.append(patterns[k]);
                    }
                    msg.append(")");
                }
                msg.append(" for library name \"");
                msg.append(libname);
                msg.append("\" was found.");
                project.log(msg.toString(), 1);
            }
        }
    }
}

