package deviceinfo.mayur.medialibrary.data;

/**
 * Created by mayurkaul on 02/11/17.
 */

import android.net.Uri;

public abstract class MediaObject {
    @SuppressWarnings("unused")
    private static final String TAG = "MediaObject";
    public static final long INVALID_DATA_VERSION = -1;
    // These are the bits returned from getSupportedOperations():
    public static final int SUPPORT_DELETE = 1 << 0;
    public static final int SUPPORT_ROTATE = 1 << 1;
    public static final int SUPPORT_SHARE = 1 << 2;
    public static final int SUPPORT_CROP = 1 << 3;
    public static final int SUPPORT_SHOW_ON_MAP = 1 << 4;
    public static final int SUPPORT_SETAS = 1 << 5;
    public static final int SUPPORT_FULL_IMAGE = 1 << 6;
    public static final int SUPPORT_PLAY = 1 << 7;
    public static final int SUPPORT_CACHE = 1 << 8;
    public static final int SUPPORT_EDIT = 1 << 9;
    public static final int SUPPORT_INFO = 1 << 10;
    public static final int SUPPORT_IMPORT = 1 << 11;
    public static final int SUPPORT_ALL = 0xffffffff;
    // These are the bits returned from getMediaType():
    public static final int MEDIA_TYPE_UNKNOWN = 1;
    public static final int MEDIA_TYPE_IMAGE = 2;
    public static final int MEDIA_TYPE_VIDEO = 4;
    public static final int MEDIA_TYPE_ALL = MEDIA_TYPE_IMAGE | MEDIA_TYPE_VIDEO;
    public static final String MEDIA_TYPE_IMAGE_STRING = "image";
    public static final String MEDIA_TYPE_VIDEO_STRING = "video";
    public static final String MEDIA_TYPE_ALL_STRING = "all";
    // These are flags for cache() and return values for getCacheFlag():
    public static final int CACHE_FLAG_NO = 0;
    public static final int CACHE_FLAG_SCREENNAIL = 1;
    public static final int CACHE_FLAG_FULL = 2;
    // These are return values for getCacheStatus():
    public static final int CACHE_STATUS_NOT_CACHED = 0;
    public static final int CACHE_STATUS_CACHING = 1;
    public static final int CACHE_STATUS_CACHED_SCREENNAIL = 2;
    public static final int CACHE_STATUS_CACHED_FULL = 3;
    private static long sVersionSerial = 0;
    protected long mDataVersion;
    protected final Path mPath;
    public MediaObject(Path path, long version) {
        path.setObject(this);
        mPath = path;
        mDataVersion = version;
    }
    public Path getPath() {
        return mPath;
    }
    public int getSupportedOperations() {
        return 0;
    }
    public void delete() {
        throw new UnsupportedOperationException();
    }
    public void rotate(int degrees) throws Exception {
        throw new UnsupportedOperationException();
    }
    public Uri getContentUri() {
        throw new UnsupportedOperationException();
    }
    public Uri getPlayUri() {
        throw new UnsupportedOperationException();
    }
    public int getMediaType() {
        return MEDIA_TYPE_UNKNOWN;
    }
    public boolean Import() {
        throw new UnsupportedOperationException();
    }
    public MediaDetails getDetails() {
        MediaDetails details = new MediaDetails();
        return details;
    }
    public long getDataVersion() {
        return mDataVersion;
    }
    public int getCacheFlag() {
        return CACHE_FLAG_NO;
    }
    public int getCacheStatus() {
        throw new UnsupportedOperationException();
    }
    public long getCacheSize() {
        throw new UnsupportedOperationException();
    }
    public void cache(int flag) {
        throw new UnsupportedOperationException();
    }
    public static synchronized long nextVersionNumber() {
        return ++MediaObject.sVersionSerial;
    }
    public static int getTypeFromString(String s) {
        if (MEDIA_TYPE_ALL_STRING.equals(s)) return MediaObject.MEDIA_TYPE_ALL;
        if (MEDIA_TYPE_IMAGE_STRING.equals(s)) return MediaObject.MEDIA_TYPE_IMAGE;
        if (MEDIA_TYPE_VIDEO_STRING.equals(s)) return MediaObject.MEDIA_TYPE_VIDEO;
        throw new IllegalArgumentException(s);
    }
    public static String getTypeString(int type) {
        switch (type) {
            case MEDIA_TYPE_IMAGE: return MEDIA_TYPE_IMAGE_STRING;
            case MEDIA_TYPE_VIDEO: return MEDIA_TYPE_VIDEO_STRING;
            case MEDIA_TYPE_ALL: return MEDIA_TYPE_ALL_STRING;
        }
        throw new IllegalArgumentException();
    }
}