/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import deviceinfo.mayur.medialibrary.data.MediaObject;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.ApiHelper;
import deviceinfo.mayur.medialibrary.util.ThreadPool;
import deviceinfo.mayur.medialibrary.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class BucketHelper {
    private static final String TAG = "BucketHelper";
    private static final String EXTERNAL_MEDIA = "external";
    private static final String[] PROJECTION_BUCKET = new String[]{"bucket_id", "media_type", "bucket_display_name"};
    private static final int INDEX_BUCKET_ID = 0;
    private static final int INDEX_MEDIA_TYPE = 1;
    private static final int INDEX_BUCKET_NAME = 2;
    private static final String BUCKET_GROUP_BY = "1) GROUP BY 1,(2";
    private static final String BUCKET_ORDER_BY = "MAX(datetaken) DESC";
    private static final String[] PROJECTION_BUCKET_IN_ONE_TABLE = new String[]{"bucket_id", "MAX(datetaken)", "bucket_display_name"};
    private static final int INDEX_DATE_TAKEN = 1;
    private static final String BUCKET_GROUP_BY_IN_ONE_TABLE = "1) GROUP BY (1";
    private static final Uri mBaseUri = MediaStore.Files.getContentUri((String)"external");

    public static BucketEntry[] loadBucketEntries(ThreadPool.JobContext jc, ContentResolver resolver, int type) {
        if (ApiHelper.HAS_MEDIA_PROVIDER_FILES_TABLE) {
            return BucketHelper.loadBucketEntriesFromFilesTable(jc, resolver, type);
        }
        return BucketHelper.loadBucketEntriesFromImagesAndVideoTable(jc, resolver, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateBucketEntriesFromTable(ThreadPool.JobContext jc, ContentResolver resolver, Uri tableUri, HashMap<Integer, BucketEntry> buckets) {
        Cursor cursor = resolver.query(tableUri, PROJECTION_BUCKET_IN_ONE_TABLE, BUCKET_GROUP_BY_IN_ONE_TABLE, null, null);
        if (cursor == null) {
            Log.w((String)TAG, (String)("cannot open media database: " + tableUri));
            return;
        }
        try {
            while (cursor.moveToNext()) {
                int bucketId = cursor.getInt(0);
                int dateTaken = cursor.getInt(1);
                BucketEntry entry = buckets.get(bucketId);
                if (entry == null) {
                    entry = new BucketEntry(bucketId, cursor.getString(2));
                    buckets.put(bucketId, entry);
                    entry.dateTaken = dateTaken;
                    continue;
                }
                entry.dateTaken = Math.max(entry.dateTaken, dateTaken);
            }
        }
        finally {
            Utils.closeSilently(cursor);
        }
    }

    private static BucketEntry[] loadBucketEntriesFromImagesAndVideoTable(ThreadPool.JobContext jc, ContentResolver resolver, int type) {
        HashMap<Integer, BucketEntry> buckets = new HashMap<Integer, BucketEntry>(64);
        if ((type & 2) != 0) {
            BucketHelper.updateBucketEntriesFromTable(jc, resolver, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, buckets);
        }
        if ((type & 4) != 0) {
            BucketHelper.updateBucketEntriesFromTable(jc, resolver, MediaStore.Video.Media.EXTERNAL_CONTENT_URI, buckets);
        }
        BucketEntry[] entries = buckets.values().toArray(new BucketEntry[buckets.size()]);
        Arrays.sort(entries, new Comparator<BucketEntry>(){

            @Override
            public int compare(BucketEntry a, BucketEntry b) {
                return b.dateTaken - a.dateTaken;
            }
        });
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BucketEntry[] loadBucketEntriesFromFilesTable(ThreadPool.JobContext jc, ContentResolver resolver, int type) {
        Uri uri = BucketHelper.getFilesContentUri();
        Cursor cursor = resolver.query(uri, PROJECTION_BUCKET, BUCKET_GROUP_BY, null, BUCKET_ORDER_BY);
        if (cursor == null) {
            Log.w((String)TAG, (String)("cannot open local database: " + uri));
            return new BucketEntry[0];
        }
        ArrayList<BucketEntry> buffer = new ArrayList<BucketEntry>();
        int typeBits = 0;
        if ((type & 2) != 0) {
            typeBits |= 2;
        }
        if ((type & 4) != 0) {
            typeBits |= 8;
        }
        try {
            while (cursor.moveToNext()) {
                BucketEntry entry;
                if ((typeBits & 1 << cursor.getInt(1)) != 0 && !buffer.contains(entry = new BucketEntry(cursor.getInt(0), cursor.getString(2)))) {
                    buffer.add(entry);
                }
                if (!jc.isCancelled()) continue;
                BucketEntry[] bucketEntryArray = null;
                return bucketEntryArray;
            }
        }
        finally {
            Utils.closeSilently(cursor);
        }
        return buffer.toArray(new BucketEntry[buffer.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBucketNameInTable(ContentResolver resolver, Uri tableUri, int bucketId) {
        String[] selectionArgs = new String[]{String.valueOf(bucketId)};
        Uri uri = tableUri.buildUpon().appendQueryParameter("limit", "1").build();
        Cursor cursor = resolver.query(uri, PROJECTION_BUCKET_IN_ONE_TABLE, "bucket_id = ?", selectionArgs, null);
        try {
            if (cursor != null && cursor.moveToNext()) {
                String string = cursor.getString(2);
                return string;
            }
        }
        finally {
            Utils.closeSilently(cursor);
        }
        return null;
    }

    @TargetApi(value=11)
    private static Uri getFilesContentUri() {
        return MediaStore.Files.getContentUri((String)EXTERNAL_MEDIA);
    }

    public static String getBucketName(ContentResolver resolver, int bucketId) {
        if (ApiHelper.HAS_MEDIA_PROVIDER_FILES_TABLE) {
            String result = BucketHelper.getBucketNameInTable(resolver, BucketHelper.getFilesContentUri(), bucketId);
            return result == null ? "" : result;
        }
        String result = BucketHelper.getBucketNameInTable(resolver, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, bucketId);
        if (result != null) {
            return result;
        }
        result = BucketHelper.getBucketNameInTable(resolver, MediaStore.Video.Media.EXTERNAL_CONTENT_URI, bucketId);
        return result == null ? "" : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BucketEntry[] loadBucketEntries(Path path, ThreadPool.JobContext jc, Context mContext) {
        Uri uri = mBaseUri;
        Log.v((String)"DebugLoadingTime", (String)"start quering media provider");
        Cursor cursor = mContext.getContentResolver().query(uri, PROJECTION_BUCKET, BUCKET_GROUP_BY, null, BUCKET_ORDER_BY);
        if (cursor == null) {
            Log.w((String)TAG, (String)("cannot open local database: " + uri));
            return new BucketEntry[0];
        }
        ArrayList<BucketEntry> buffer = new ArrayList<BucketEntry>();
        int typeBits = 0;
        int mType = BucketHelper.getTypeFromPath(path);
        if ((mType & 2) != 0) {
            typeBits |= 2;
        }
        if ((mType & 4) != 0) {
            typeBits |= 8;
        }
        try {
            while (cursor.moveToNext()) {
                BucketEntry entry;
                if ((typeBits & 1 << cursor.getInt(1)) != 0 && !buffer.contains(entry = new BucketEntry(cursor.getInt(0), cursor.getString(2)))) {
                    buffer.add(entry);
                }
                if (!jc.isCancelled()) continue;
                BucketEntry[] bucketEntryArray = null;
                return bucketEntryArray;
            }
            Log.v((String)"DebugLoadingTime", (String)("got " + buffer.size() + " buckets"));
        }
        finally {
            cursor.close();
        }
        return buffer.toArray(new BucketEntry[buffer.size()]);
    }

    private static int getTypeFromPath(Path path) {
        String[] name = path.split();
        if (name.length < 2) {
            throw new IllegalArgumentException(path.toString());
        }
        return MediaObject.getTypeFromString(name[1]);
    }

    public static class BucketEntry {
        public String bucketName;
        public int bucketId;
        public int dateTaken;

        public BucketEntry(int id, String name) {
            this.bucketId = id;
            this.bucketName = Utils.ensureNotNull(name);
        }

        public int hashCode() {
            return this.bucketId;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BucketEntry)) {
                return false;
            }
            BucketEntry entry = (BucketEntry)object;
            return this.bucketId == entry.bucketId;
        }
    }
}

