/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import deviceinfo.mayur.medialibrary.util.ThreadPool;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class BytesBufferPool {
    private static final int READ_STEP = 4096;
    private final int mPoolSize;
    private final int mBufferSize;
    private final ArrayList<BytesBuffer> mList;

    public BytesBufferPool(int poolSize, int bufferSize) {
        this.mList = new ArrayList(poolSize);
        this.mPoolSize = poolSize;
        this.mBufferSize = bufferSize;
    }

    public synchronized BytesBuffer get() {
        int n = this.mList.size();
        return n > 0 ? this.mList.remove(n - 1) : new BytesBuffer(this.mBufferSize);
    }

    public synchronized void recycle(BytesBuffer buffer) {
        if (buffer.data.length != this.mBufferSize) {
            return;
        }
        if (this.mList.size() < this.mPoolSize) {
            buffer.offset = 0;
            buffer.length = 0;
            this.mList.add(buffer);
        }
    }

    public synchronized void clear() {
        this.mList.clear();
    }

    public static class BytesBuffer {
        public byte[] data;
        public int offset;
        public int length;

        private BytesBuffer(int capacity) {
            this.data = new byte[capacity];
        }

        public void readFrom(ThreadPool.JobContext jc, FileDescriptor fd) throws IOException {
            this.length = 0;
            try (FileInputStream fis = new FileInputStream(fd);){
                int capacity = this.data.length;
                while (true) {
                    int step;
                    int rc;
                    if ((rc = fis.read(this.data, this.length, step = Math.min(4096, capacity - this.length))) < 0 || jc.isCancelled()) {
                        return;
                    }
                    this.length += rc;
                    if (this.length != capacity) continue;
                    byte[] newData = new byte[this.data.length * 2];
                    System.arraycopy(this.data, 0, newData, 0, this.data.length);
                    this.data = newData;
                    capacity = this.data.length;
                }
            }
        }
    }
}

