/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.net.Uri;
import deviceinfo.mayur.medialibrary.data.MediaDataContext;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChangeNotifier {
    private MediaSet mMediaSet;
    private AtomicBoolean mContentDirty = new AtomicBoolean(true);

    public ChangeNotifier(MediaSet set, Uri uri, MediaDataContext application) {
        this.mMediaSet = set;
        application.getDataManager().registerChangeNotifier(uri, this);
    }

    public ChangeNotifier(MediaSet set, Uri[] uris, MediaDataContext application) {
        this.mMediaSet = set;
        for (int i = 0; i < uris.length; ++i) {
            application.getDataManager().registerChangeNotifier(uris[i], this);
        }
    }

    public boolean isDirty() {
        return this.mContentDirty.compareAndSet(true, false);
    }

    public void fakeChange() {
        this.onChange(false);
    }

    protected void onChange(boolean selfChange) {
        if (this.mContentDirty.compareAndSet(false, true)) {
            this.mMediaSet.notifyContentChanged();
        }
    }
}

