/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.content.Context;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import deviceinfo.mayur.medialibrary.data.SmallItem;
import java.util.ArrayList;

class Cluster {
    private static final String TAG = "Cluster";
    private static final String MMDDYY_FORMAT = "MMddyy";
    public boolean mGeographicallySeparatedFromPrevCluster = false;
    private ArrayList<SmallItem> mItems = new ArrayList();

    public void addItem(SmallItem item) {
        this.mItems.add(item);
    }

    public int size() {
        return this.mItems.size();
    }

    public SmallItem getLastItem() {
        int n = this.mItems.size();
        return n == 0 ? null : this.mItems.get(n - 1);
    }

    public ArrayList<SmallItem> getItems() {
        return this.mItems;
    }

    public String generateCaption(Context context) {
        String caption;
        int n = this.mItems.size();
        long minTimestamp = 0L;
        long maxTimestamp = 0L;
        for (int i = 0; i < n; ++i) {
            long t = this.mItems.get((int)i).dateInMs;
            if (t == 0L) continue;
            if (minTimestamp == 0L) {
                minTimestamp = maxTimestamp = t;
                continue;
            }
            minTimestamp = Math.min(minTimestamp, t);
            maxTimestamp = Math.max(maxTimestamp, t);
        }
        if (minTimestamp == 0L) {
            return "";
        }
        String minDay = DateFormat.format((CharSequence)MMDDYY_FORMAT, (long)minTimestamp).toString();
        String maxDay = DateFormat.format((CharSequence)MMDDYY_FORMAT, (long)maxTimestamp).toString();
        if (minDay.substring(4).equals(maxDay.substring(4))) {
            String dateRangeWithYear;
            int flags;
            String dateRangeWithOptionalYear;
            caption = DateUtils.formatDateRange((Context)context, (long)minTimestamp, (long)maxTimestamp, (int)524288);
            if (minDay.equals(maxDay) && !(dateRangeWithOptionalYear = DateUtils.formatDateTime((Context)context, (long)minTimestamp, (int)(flags = 65552))).equals(dateRangeWithYear = DateUtils.formatDateTime((Context)context, (long)minTimestamp, (int)(flags | 4)))) {
                long midTimestamp = (minTimestamp + maxTimestamp) / 2L;
                caption = DateUtils.formatDateRange((Context)context, (long)midTimestamp, (long)midTimestamp, (int)(1 | flags));
            }
        } else {
            int flags = 65584;
            caption = DateUtils.formatDateRange((Context)context, (long)minTimestamp, (long)maxTimestamp, (int)flags);
        }
        return caption;
    }
}

