/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import deviceinfo.mayur.medialibrary.data.ContentListener;
import deviceinfo.mayur.medialibrary.data.DataManager;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.Path;
import java.util.ArrayList;

public class ClusterAlbum
extends MediaSet
implements ContentListener {
    private static final String TAG = "ClusterAlbum";
    private ArrayList<Path> mPaths = new ArrayList();
    private String mName = "";
    private DataManager mDataManager;
    private MediaSet mClusterAlbumSet;
    private MediaItem mCover;

    public ClusterAlbum(Path path, DataManager dataManager, MediaSet clusterAlbumSet) {
        super(path, ClusterAlbum.nextVersionNumber());
        this.mDataManager = dataManager;
        this.mClusterAlbumSet = clusterAlbumSet;
        this.mClusterAlbumSet.addContentListener(this);
    }

    public void setCoverMediaItem(MediaItem cover) {
        this.mCover = cover;
    }

    @Override
    public MediaItem getCoverMediaItem() {
        return this.mCover != null ? this.mCover : super.getCoverMediaItem();
    }

    void setMediaItems(ArrayList<Path> paths) {
        this.mPaths = paths;
    }

    ArrayList<Path> getMediaItems() {
        return this.mPaths;
    }

    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public int getMediaItemCount() {
        return this.mPaths.size();
    }

    @Override
    public ArrayList<MediaItem> getMediaItem(int start, int count) {
        return ClusterAlbum.getMediaItemFromPath(this.mPaths, start, count, this.mDataManager);
    }

    public static ArrayList<MediaItem> getMediaItemFromPath(ArrayList<Path> paths, int start, int count, DataManager dataManager) {
        if (start >= paths.size()) {
            return new ArrayList<MediaItem>();
        }
        int end = Math.min(start + count, paths.size());
        ArrayList<Path> subset = new ArrayList<Path>(paths.subList(start, end));
        final MediaItem[] buf = new MediaItem[end - start];
        MediaSet.ItemConsumer consumer = new MediaSet.ItemConsumer(){

            @Override
            public void consume(int index, MediaItem item) {
                buf[index] = item;
            }
        };
        dataManager.mapMediaItems(subset, consumer, 0);
        ArrayList<MediaItem> result = new ArrayList<MediaItem>();
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] == null) continue;
            result.add(buf[i]);
        }
        return result;
    }

    @Override
    protected int enumerateMediaItems(MediaSet.ItemConsumer consumer, int startIndex) {
        this.mDataManager.mapMediaItems(this.mPaths, consumer, startIndex);
        return this.mPaths.size();
    }

    @Override
    public int getTotalMediaItemCount() {
        return this.mPaths.size();
    }

    @Override
    public long reload() {
        if (this.mClusterAlbumSet.reload() > this.mDataVersion) {
            this.mDataVersion = ClusterAlbum.nextVersionNumber();
        }
        return this.mDataVersion;
    }

    @Override
    public void onContentDirty() {
        this.notifyContentChanged();
    }

    @Override
    public int getSupportedOperations() {
        return 1029;
    }

    @Override
    public void delete() {
        MediaSet.ItemConsumer consumer = new MediaSet.ItemConsumer(){

            @Override
            public void consume(int index, MediaItem item) {
                if ((item.getSupportedOperations() & 1) != 0) {
                    item.delete();
                }
            }
        };
        this.mDataManager.mapMediaItems(this.mPaths, consumer, 0);
    }

    @Override
    public boolean isLeafAlbum() {
        return true;
    }
}

