/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.content.Context;
import android.net.Uri;
import deviceinfo.mayur.medialibrary.data.ClusterAlbum;
import deviceinfo.mayur.medialibrary.data.Clustering;
import deviceinfo.mayur.medialibrary.data.ContentListener;
import deviceinfo.mayur.medialibrary.data.DataManager;
import deviceinfo.mayur.medialibrary.data.FaceClustering;
import deviceinfo.mayur.medialibrary.data.LocationClustering;
import deviceinfo.mayur.medialibrary.data.MediaDataContext;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.data.SizeClustering;
import deviceinfo.mayur.medialibrary.data.TagClustering;
import deviceinfo.mayur.medialibrary.data.TimeClustering;
import java.util.ArrayList;
import java.util.HashSet;

public class ClusterAlbumSet
extends MediaSet
implements ContentListener {
    private static final String TAG = "ClusterAlbumSet";
    private MediaDataContext mApplication;
    private MediaSet mBaseSet;
    private int mKind;
    private ArrayList<ClusterAlbum> mAlbums = new ArrayList();
    private boolean mFirstReloadDone;

    public ClusterAlbumSet(Path path, MediaDataContext application, MediaSet baseSet, int kind) {
        super(path, -1L);
        this.mApplication = application;
        this.mBaseSet = baseSet;
        this.mKind = kind;
        baseSet.addContentListener(this);
    }

    @Override
    public MediaSet getSubMediaSet(int index) {
        return this.mAlbums.get(index);
    }

    @Override
    public int getSubMediaSetCount() {
        return this.mAlbums.size();
    }

    @Override
    public String getName() {
        return this.mBaseSet.getName();
    }

    @Override
    public long reload() {
        if (this.mBaseSet.reload() > this.mDataVersion) {
            if (this.mFirstReloadDone) {
                this.updateClustersContents();
            } else {
                this.updateClusters();
                this.mFirstReloadDone = true;
            }
            this.mDataVersion = ClusterAlbumSet.nextVersionNumber();
        }
        return this.mDataVersion;
    }

    @Override
    public void onContentDirty() {
        this.updateClusters();
        this.notifyContentChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClusters() {
        Clustering clustering;
        this.mAlbums.clear();
        Context context = this.mApplication.getContext();
        switch (this.mKind) {
            case 0: {
                clustering = new TimeClustering(context);
                break;
            }
            case 1: {
                clustering = new LocationClustering(context);
                break;
            }
            case 2: {
                clustering = new TagClustering(context);
                break;
            }
            case 4: {
                clustering = new FaceClustering(context);
                break;
            }
            default: {
                clustering = new SizeClustering(context);
            }
        }
        clustering.run(this.mBaseSet);
        int n = clustering.getNumberOfClusters();
        DataManager dataManager = this.mApplication.getDataManager();
        for (int i = 0; i < n; ++i) {
            ClusterAlbum album;
            Path childPath;
            String childName = clustering.getClusterName(i);
            if (this.mKind == 2) {
                childPath = this.mPath.getChild(Uri.encode((String)childName));
            } else if (this.mKind == 3) {
                long minSize = ((SizeClustering)clustering).getMinSize(i);
                childPath = this.mPath.getChild(minSize);
            } else {
                childPath = this.mPath.getChild(i);
            }
            Object object = DataManager.LOCK;
            synchronized (object) {
                album = (ClusterAlbum)dataManager.peekMediaObject(childPath);
                if (album == null) {
                    album = new ClusterAlbum(childPath, dataManager, this);
                }
            }
            album.setMediaItems(clustering.getCluster(i));
            album.setName(childName);
            album.setCoverMediaItem(clustering.getClusterCover(i));
            this.mAlbums.add(album);
        }
    }

    private void updateClustersContents() {
        final HashSet existing = new HashSet();
        this.mBaseSet.enumerateTotalMediaItems(new MediaSet.ItemConsumer(){

            @Override
            public void consume(int index, MediaItem item) {
                existing.add(item.getPath());
            }
        });
        int n = this.mAlbums.size();
        for (int i = n - 1; i >= 0; --i) {
            ArrayList<Path> oldPaths = this.mAlbums.get(i).getMediaItems();
            ArrayList<Path> newPaths = new ArrayList<Path>();
            int m = oldPaths.size();
            for (int j = 0; j < m; ++j) {
                Path p = oldPaths.get(j);
                if (!existing.contains(p)) continue;
                newPaths.add(p);
            }
            this.mAlbums.get(i).setMediaItems(newPaths);
            if (!newPaths.isEmpty()) continue;
            this.mAlbums.remove(i);
        }
    }
}

