/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import deviceinfo.mayur.medialibrary.data.ClusterAlbum;
import deviceinfo.mayur.medialibrary.data.ClusterAlbumSet;
import deviceinfo.mayur.medialibrary.data.DataManager;
import deviceinfo.mayur.medialibrary.data.MediaDataContext;
import deviceinfo.mayur.medialibrary.data.MediaObject;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.MediaSource;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.data.PathMatcher;

class ClusterSource
extends MediaSource {
    static final int CLUSTER_ALBUMSET_TIME = 0;
    static final int CLUSTER_ALBUMSET_LOCATION = 1;
    static final int CLUSTER_ALBUMSET_TAG = 2;
    static final int CLUSTER_ALBUMSET_SIZE = 3;
    static final int CLUSTER_ALBUMSET_FACE = 4;
    static final int CLUSTER_ALBUM_TIME = 256;
    static final int CLUSTER_ALBUM_LOCATION = 257;
    static final int CLUSTER_ALBUM_TAG = 258;
    static final int CLUSTER_ALBUM_SIZE = 259;
    static final int CLUSTER_ALBUM_FACE = 260;
    MediaDataContext mApplication;
    PathMatcher mMatcher;

    public ClusterSource(MediaDataContext application) {
        super("cluster");
        this.mApplication = application;
        this.mMatcher = new PathMatcher();
        this.mMatcher.add("/cluster/*/time", 0);
        this.mMatcher.add("/cluster/*/location", 1);
        this.mMatcher.add("/cluster/*/tag", 2);
        this.mMatcher.add("/cluster/*/size", 3);
        this.mMatcher.add("/cluster/*/face", 4);
        this.mMatcher.add("/cluster/*/time/*", 256);
        this.mMatcher.add("/cluster/*/location/*", 257);
        this.mMatcher.add("/cluster/*/tag/*", 258);
        this.mMatcher.add("/cluster/*/size/*", 259);
        this.mMatcher.add("/cluster/*/face/*", 260);
    }

    @Override
    public MediaObject createMediaObject(Path path) {
        int matchType = this.mMatcher.match(path);
        String setsName = this.mMatcher.getVar(0);
        DataManager dataManager = this.mApplication.getDataManager();
        MediaSet[] sets = dataManager.getMediaSetsFromString(setsName);
        switch (matchType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new ClusterAlbumSet(path, this.mApplication, sets[0], matchType);
            }
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: {
                MediaSet parent = dataManager.getMediaSet(path.getParent());
                return new ClusterAlbum(path, dataManager, parent);
            }
        }
        throw new RuntimeException("bad path: " + path);
    }
}

