/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import deviceinfo.mayur.medialibrary.data.ChangeNotifier;
import deviceinfo.mayur.medialibrary.data.ClusterSource;
import deviceinfo.mayur.medialibrary.data.LocalSource;
import deviceinfo.mayur.medialibrary.data.MediaDataContext;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaObject;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.MediaSource;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class DataManager {
    private static volatile DataManager sSoleInstance;
    public static final int INCLUDE_IMAGE = 1;
    public static final int INCLUDE_VIDEO = 2;
    public static final int INCLUDE_ALL = 3;
    public static final int INCLUDE_LOCAL_ONLY = 4;
    public static final int INCLUDE_LOCAL_IMAGE_ONLY = 5;
    public static final int INCLUDE_LOCAL_VIDEO_ONLY = 6;
    public static final int INCLUDE_LOCAL_ALL_ONLY = 7;
    public static final Object LOCK;
    private static final String TAG = "DataManager";
    private static final String TOP_SET_PATH = "/combo/{/local/all,/picasa/all}";
    private static final String TOP_IMAGE_SET_PATH = "/combo/{/local/image,/picasa/image}";
    private static final String TOP_VIDEO_SET_PATH = "/combo/{/local/video,/picasa/video}";
    private static final String TOP_LOCAL_SET_PATH = "/local/all";
    private static final String TOP_LOCAL_IMAGE_SET_PATH = "/local/image";
    private static final String TOP_LOCAL_VIDEO_SET_PATH = "/local/video";
    public static final Comparator<MediaItem> sDateTakenComparator;
    private Handler mDefaultMainHandler;
    private MediaDataContext mApplication;
    private int mActiveCount = 0;
    private HashMap<Uri, NotifyBroker> mNotifierMap = new HashMap();
    private HashMap<String, MediaSource> mSourceMap = new LinkedHashMap<String, MediaSource>();

    public DataManager(MediaDataContext application) {
        this.mApplication = application;
        this.mDefaultMainHandler = new Handler(application.getMainLooper());
    }

    public synchronized void initializeSourceMap() {
        if (!this.mSourceMap.isEmpty()) {
            return;
        }
        this.addSource(new LocalSource(this.mApplication));
        this.addSource(new ClusterSource(this.mApplication));
        if (this.mActiveCount > 0) {
            for (MediaSource source : this.mSourceMap.values()) {
                source.resume();
            }
        }
    }

    public String getTopSetPath(int typeBits) {
        switch (typeBits) {
            case 1: {
                return TOP_IMAGE_SET_PATH;
            }
            case 2: {
                return TOP_VIDEO_SET_PATH;
            }
            case 3: {
                return TOP_SET_PATH;
            }
            case 5: {
                return TOP_LOCAL_IMAGE_SET_PATH;
            }
            case 6: {
                return TOP_LOCAL_VIDEO_SET_PATH;
            }
            case 7: {
                return TOP_LOCAL_SET_PATH;
            }
        }
        throw new IllegalArgumentException();
    }

    void addSource(MediaSource source) {
        if (source == null) {
            return;
        }
        this.mSourceMap.put(source.getPrefix(), source);
    }

    public MediaObject peekMediaObject(Path path) {
        return path.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaObject getMediaObject(Path path) {
        Object object = LOCK;
        synchronized (object) {
            MediaObject obj = path.getObject();
            if (obj != null) {
                return obj;
            }
            MediaSource source = this.mSourceMap.get(path.getPrefix());
            if (source == null) {
                Log.w((String)TAG, (String)("cannot find media source for path: " + path));
                return null;
            }
            try {
                MediaObject object2 = source.createMediaObject(path);
                if (object2 == null) {
                    Log.w((String)TAG, (String)("cannot create media object: " + path));
                }
                return object2;
            }
            catch (Throwable t) {
                Log.w((String)TAG, (String)("exception in creating media object: " + path), (Throwable)t);
                return null;
            }
        }
    }

    public MediaObject getMediaObject(String s) {
        return this.getMediaObject(Path.fromString(s));
    }

    public MediaSet getMediaSet(Path path) {
        return (MediaSet)this.getMediaObject(path);
    }

    public MediaSet getMediaSet(String s) {
        return (MediaSet)this.getMediaObject(s);
    }

    public MediaSet[] getMediaSetsFromString(String segment) {
        String[] seq = Path.splitSequence(segment);
        int n = seq.length;
        MediaSet[] sets = new MediaSet[n];
        for (int i = 0; i < n; ++i) {
            sets[i] = this.getMediaSet(seq[i]);
        }
        return sets;
    }

    public void mapMediaItems(ArrayList<Path> list, MediaSet.ItemConsumer consumer, int startIndex) {
        String prefix;
        HashMap<String, ArrayList<MediaSource.PathId>> map = new HashMap<String, ArrayList<MediaSource.PathId>>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Path path = list.get(i);
            prefix = path.getPrefix();
            ArrayList<MediaSource.PathId> group = (ArrayList<MediaSource.PathId>)map.get(prefix);
            if (group == null) {
                group = new ArrayList<MediaSource.PathId>();
                map.put(prefix, group);
            }
            group.add(new MediaSource.PathId(path, i + startIndex));
        }
        for (Map.Entry entry : map.entrySet()) {
            prefix = (String)entry.getKey();
            MediaSource source = this.mSourceMap.get(prefix);
            source.mapMediaItems((ArrayList)entry.getValue(), consumer);
        }
    }

    public int getSupportedOperations(Path path) {
        return this.getMediaObject(path).getSupportedOperations();
    }

    public void delete(Path path) {
        this.getMediaObject(path).delete();
    }

    public void rotate(Path path, int degrees) {
        try {
            this.getMediaObject(path).rotate(degrees);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Uri getContentUri(Path path) {
        return this.getMediaObject(path).getContentUri();
    }

    public int getMediaType(Path path) {
        return this.getMediaObject(path).getMediaType();
    }

    public Path findPathByUri(Uri uri, String type) {
        if (uri == null) {
            return null;
        }
        for (MediaSource source : this.mSourceMap.values()) {
            Path path = source.findPathByUri(uri, type);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    public Path getDefaultSetOf(Path item) {
        MediaSource source = this.mSourceMap.get(item.getPrefix());
        return source == null ? null : source.getDefaultSetOf(item);
    }

    public long getTotalUsedCacheSize() {
        long sum = 0L;
        for (MediaSource source : this.mSourceMap.values()) {
            sum += source.getTotalUsedCacheSize();
        }
        return sum;
    }

    public long getTotalTargetCacheSize() {
        long sum = 0L;
        for (MediaSource source : this.mSourceMap.values()) {
            sum += source.getTotalTargetCacheSize();
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangeNotifier(Uri uri, ChangeNotifier notifier) {
        NotifyBroker broker = null;
        HashMap<Uri, NotifyBroker> hashMap = this.mNotifierMap;
        synchronized (hashMap) {
            broker = this.mNotifierMap.get(uri);
            if (broker == null) {
                broker = new NotifyBroker(this.mDefaultMainHandler);
                this.mApplication.getContentResolver().registerContentObserver(uri, true, (ContentObserver)broker);
                this.mNotifierMap.put(uri, broker);
            }
        }
        broker.registerNotifier(notifier);
    }

    public void resume() {
        if (++this.mActiveCount == 1) {
            for (MediaSource source : this.mSourceMap.values()) {
                source.resume();
            }
        }
    }

    public void pause() {
        if (--this.mActiveCount == 0) {
            for (MediaSource source : this.mSourceMap.values()) {
                source.pause();
            }
        }
    }

    static {
        LOCK = new Object();
        sDateTakenComparator = new DateTakenComparator();
    }

    private static class NotifyBroker
    extends ContentObserver {
        private WeakHashMap<ChangeNotifier, Object> mNotifiers = new WeakHashMap();

        public NotifyBroker(Handler handler) {
            super(handler);
        }

        public synchronized void registerNotifier(ChangeNotifier notifier) {
            this.mNotifiers.put(notifier, null);
        }

        public synchronized void onChange(boolean selfChange) {
            for (ChangeNotifier notifier : this.mNotifiers.keySet()) {
                notifier.onChange(selfChange);
            }
        }
    }

    private static class DateTakenComparator
    implements Comparator<MediaItem> {
        private DateTakenComparator() {
        }

        @Override
        public int compare(MediaItem item1, MediaItem item2) {
            return -Utils.compare(item1.getDateInMs(), item2.getDateInMs());
        }
    }
}

