/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.util.Log;
import deviceinfo.mayur.medialibrary.data.GalleryBitmapPool;
import deviceinfo.mayur.medialibrary.util.ApiHelper;
import deviceinfo.mayur.medialibrary.util.BitmapUtils;
import deviceinfo.mayur.medialibrary.util.ThreadPool;
import deviceinfo.mayur.medialibrary.util.Utils;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;

public class DecodeUtils {
    private static final String TAG = "DecodeUtils";

    @TargetApi(value=11)
    public static void setOptionsMutable(BitmapFactory.Options options) {
        if (ApiHelper.HAS_OPTIONS_IN_MUTABLE) {
            options.inMutable = true;
        }
    }

    public static Bitmap decode(ThreadPool.JobContext jc, FileDescriptor fd, BitmapFactory.Options options) {
        if (options == null) {
            options = new BitmapFactory.Options();
        }
        jc.setCancelListener(new DecodeCanceller(options));
        DecodeUtils.setOptionsMutable(options);
        return DecodeUtils.ensureGLCompatibleBitmap(BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options));
    }

    public static void decodeBounds(ThreadPool.JobContext jc, FileDescriptor fd, BitmapFactory.Options options) {
        Utils.assertTrue(options != null);
        options.inJustDecodeBounds = true;
        jc.setCancelListener(new DecodeCanceller(options));
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
    }

    public static Bitmap decode(ThreadPool.JobContext jc, byte[] bytes, BitmapFactory.Options options) {
        return DecodeUtils.decode(jc, bytes, 0, bytes.length, options);
    }

    public static Bitmap decode(ThreadPool.JobContext jc, byte[] bytes, int offset, int length, BitmapFactory.Options options) {
        if (options == null) {
            options = new BitmapFactory.Options();
        }
        jc.setCancelListener(new DecodeCanceller(options));
        DecodeUtils.setOptionsMutable(options);
        return DecodeUtils.ensureGLCompatibleBitmap(BitmapFactory.decodeByteArray((byte[])bytes, (int)offset, (int)length, (BitmapFactory.Options)options));
    }

    public static void decodeBounds(ThreadPool.JobContext jc, byte[] bytes, int offset, int length, BitmapFactory.Options options) {
        Utils.assertTrue(options != null);
        options.inJustDecodeBounds = true;
        jc.setCancelListener(new DecodeCanceller(options));
        BitmapFactory.decodeByteArray((byte[])bytes, (int)offset, (int)length, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeThumbnail(ThreadPool.JobContext jc, String filePath, BitmapFactory.Options options, int targetSize, int type) {
        Bitmap bitmap;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            FileDescriptor fd = fis.getFD();
            bitmap = DecodeUtils.decodeThumbnail(jc, fd, options, targetSize, type);
        }
        catch (Exception ex) {
            Bitmap bitmap2;
            try {
                Log.w((String)TAG, (Throwable)ex);
                bitmap2 = null;
            }
            catch (Throwable throwable) {
                Utils.closeSilently(fis);
                throw throwable;
            }
            Utils.closeSilently(fis);
            return bitmap2;
        }
        Utils.closeSilently(fis);
        return bitmap;
    }

    public static Bitmap decodeThumbnail(ThreadPool.JobContext jc, FileDescriptor fd, BitmapFactory.Options options, int targetSize, int type) {
        float scale;
        if (options == null) {
            options = new BitmapFactory.Options();
        }
        jc.setCancelListener(new DecodeCanceller(options));
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        if (jc.isCancelled()) {
            return null;
        }
        int w = options.outWidth;
        int h = options.outHeight;
        if (type == 2) {
            scale = (float)targetSize / (float)Math.min(w, h);
            options.inSampleSize = BitmapUtils.computeSampleSizeLarger(scale);
            int MAX_PIXEL_COUNT = 640000;
            if (w / options.inSampleSize * (h / options.inSampleSize) > 640000) {
                options.inSampleSize = BitmapUtils.computeSampleSize((float)Math.sqrt(640000.0 / (double)(w * h)));
            }
        } else {
            scale = (float)targetSize / (float)Math.max(w, h);
            options.inSampleSize = BitmapUtils.computeSampleSizeLarger(scale);
        }
        options.inJustDecodeBounds = false;
        DecodeUtils.setOptionsMutable(options);
        Bitmap result = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        if (result == null) {
            return null;
        }
        float scale2 = (float)targetSize / (float)(type == 2 ? Math.min(result.getWidth(), result.getHeight()) : Math.max(result.getWidth(), result.getHeight()));
        if ((double)scale2 <= 0.5) {
            result = BitmapUtils.resizeBitmapByScale(result, scale2, true);
        }
        return DecodeUtils.ensureGLCompatibleBitmap(result);
    }

    public static Bitmap decodeIfBigEnough(ThreadPool.JobContext jc, byte[] data, BitmapFactory.Options options, int targetSize) {
        if (options == null) {
            options = new BitmapFactory.Options();
        }
        jc.setCancelListener(new DecodeCanceller(options));
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        if (jc.isCancelled()) {
            return null;
        }
        if (options.outWidth < targetSize || options.outHeight < targetSize) {
            return null;
        }
        options.inSampleSize = BitmapUtils.computeSampleSizeLarger(options.outWidth, options.outHeight, targetSize);
        options.inJustDecodeBounds = false;
        DecodeUtils.setOptionsMutable(options);
        return DecodeUtils.ensureGLCompatibleBitmap(BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options));
    }

    public static Bitmap ensureGLCompatibleBitmap(Bitmap bitmap) {
        if (bitmap == null || bitmap.getConfig() != null) {
            return bitmap;
        }
        Bitmap newBitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        bitmap.recycle();
        return newBitmap;
    }

    public static BitmapRegionDecoder createBitmapRegionDecoder(ThreadPool.JobContext jc, byte[] bytes, int offset, int length, boolean shareable) {
        if (offset < 0 || length <= 0 || offset + length > bytes.length) {
            throw new IllegalArgumentException(String.format("offset = %s, length = %s, bytes = %s", offset, length, bytes.length));
        }
        try {
            return BitmapRegionDecoder.newInstance((byte[])bytes, (int)offset, (int)length, (boolean)shareable);
        }
        catch (Throwable t) {
            Log.w((String)TAG, (Throwable)t);
            return null;
        }
    }

    public static BitmapRegionDecoder createBitmapRegionDecoder(ThreadPool.JobContext jc, String filePath, boolean shareable) {
        try {
            return BitmapRegionDecoder.newInstance((String)filePath, (boolean)shareable);
        }
        catch (Throwable t) {
            Log.w((String)TAG, (Throwable)t);
            return null;
        }
    }

    public static BitmapRegionDecoder createBitmapRegionDecoder(ThreadPool.JobContext jc, FileDescriptor fd, boolean shareable) {
        try {
            return BitmapRegionDecoder.newInstance((FileDescriptor)fd, (boolean)shareable);
        }
        catch (Throwable t) {
            Log.w((String)TAG, (Throwable)t);
            return null;
        }
    }

    public static BitmapRegionDecoder createBitmapRegionDecoder(ThreadPool.JobContext jc, InputStream is, boolean shareable) {
        try {
            return BitmapRegionDecoder.newInstance((InputStream)is, (boolean)shareable);
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)("requestCreateBitmapRegionDecoder: " + t));
            return null;
        }
    }

    @TargetApi(value=11)
    public static Bitmap decodeUsingPool(ThreadPool.JobContext jc, byte[] data, int offset, int length, BitmapFactory.Options options) {
        if (options == null) {
            options = new BitmapFactory.Options();
        }
        if (options.inSampleSize < 1) {
            options.inSampleSize = 1;
        }
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inBitmap = options.inSampleSize == 1 ? DecodeUtils.findCachedBitmap(jc, data, offset, length, options) : null;
        try {
            Bitmap bitmap = DecodeUtils.decode(jc, data, offset, length, options);
            if (options.inBitmap != null && options.inBitmap != bitmap) {
                GalleryBitmapPool.getInstance().put(options.inBitmap);
                options.inBitmap = null;
            }
            return bitmap;
        }
        catch (IllegalArgumentException e) {
            if (options.inBitmap == null) {
                throw e;
            }
            Log.w((String)TAG, (String)"decode fail with a given bitmap, try decode to a new bitmap");
            GalleryBitmapPool.getInstance().put(options.inBitmap);
            options.inBitmap = null;
            return DecodeUtils.decode(jc, data, offset, length, options);
        }
    }

    @TargetApi(value=11)
    public static Bitmap decodeUsingPool(ThreadPool.JobContext jc, FileDescriptor fileDescriptor, BitmapFactory.Options options) {
        if (options == null) {
            options = new BitmapFactory.Options();
        }
        if (options.inSampleSize < 1) {
            options.inSampleSize = 1;
        }
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inBitmap = options.inSampleSize == 1 ? DecodeUtils.findCachedBitmap(jc, fileDescriptor, options) : null;
        try {
            Bitmap bitmap = DecodeUtils.decode(jc, fileDescriptor, options);
            if (options.inBitmap != null && options.inBitmap != bitmap) {
                GalleryBitmapPool.getInstance().put(options.inBitmap);
                options.inBitmap = null;
            }
            return bitmap;
        }
        catch (IllegalArgumentException e) {
            if (options.inBitmap == null) {
                throw e;
            }
            Log.w((String)TAG, (String)"decode fail with a given bitmap, try decode to a new bitmap");
            GalleryBitmapPool.getInstance().put(options.inBitmap);
            options.inBitmap = null;
            return DecodeUtils.decode(jc, fileDescriptor, options);
        }
    }

    private static Bitmap findCachedBitmap(ThreadPool.JobContext jc, byte[] data, int offset, int length, BitmapFactory.Options options) {
        DecodeUtils.decodeBounds(jc, data, offset, length, options);
        return GalleryBitmapPool.getInstance().get(options.outWidth, options.outHeight);
    }

    private static Bitmap findCachedBitmap(ThreadPool.JobContext jc, FileDescriptor fileDescriptor, BitmapFactory.Options options) {
        DecodeUtils.decodeBounds(jc, fileDescriptor, options);
        return GalleryBitmapPool.getInstance().get(options.outWidth, options.outHeight);
    }

    private static class DecodeCanceller
    implements ThreadPool.CancelListener {
        BitmapFactory.Options mOptions;

        public DecodeCanceller(BitmapFactory.Options options) {
            this.mOptions = options;
        }

        @Override
        public void onCancel() {
            this.mOptions.requestCancelDecode();
        }
    }
}

