/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.graphics.RectF;
import deviceinfo.mayur.medialibrary.util.Utils;

public class Face
implements Comparable<Face> {
    private String mName;
    private String mPersonId;
    private RectF mPosition;

    public Face(String name, String personId, RectF rect) {
        this.mName = name;
        this.mPersonId = personId;
        Utils.assertTrue(this.mName != null && this.mPersonId != null && rect != null);
        this.mPosition = rect;
    }

    public RectF getPosition() {
        return this.mPosition;
    }

    public int getWidth() {
        return (int)(this.mPosition.right - this.mPosition.left);
    }

    public int getHeight() {
        return (int)(this.mPosition.bottom - this.mPosition.top);
    }

    public String getName() {
        return this.mName;
    }

    public String getPersonId() {
        return this.mPersonId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Face) {
            Face face = (Face)obj;
            return this.mPersonId.equals(face.mPersonId);
        }
        return false;
    }

    @Override
    public int compareTo(Face another) {
        return this.mName.compareTo(another.mName);
    }
}

