/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.content.Context;
import android.graphics.RectF;
import deviceinfo.mayur.medialibrary.R;
import deviceinfo.mayur.medialibrary.data.Clustering;
import deviceinfo.mayur.medialibrary.data.Face;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.Path;
import java.util.ArrayList;
import java.util.TreeMap;

public class FaceClustering
extends Clustering {
    private static final String TAG = "FaceClustering";
    private FaceCluster[] mClusters;
    private String mUntaggedString;
    private Context mContext;

    public FaceClustering(Context context) {
        this.mUntaggedString = context.getResources().getString(R.string.untagged);
        this.mContext = context;
    }

    @Override
    public void run(MediaSet baseSet) {
        final TreeMap map = new TreeMap();
        final FaceCluster untagged = new FaceCluster(this.mUntaggedString);
        baseSet.enumerateTotalMediaItems(new MediaSet.ItemConsumer(){

            @Override
            public void consume(int index, MediaItem item) {
                Face[] faces = item.getFaces();
                if (faces == null || faces.length == 0) {
                    untagged.add(item, -1);
                    return;
                }
                for (int j = 0; j < faces.length; ++j) {
                    Face face = faces[j];
                    FaceCluster cluster = (FaceCluster)map.get(face);
                    if (cluster == null) {
                        cluster = new FaceCluster(face.getName());
                        map.put(face, cluster);
                    }
                    cluster.add(item, j);
                }
            }
        });
        int m = map.size();
        this.mClusters = map.values().toArray(new FaceCluster[m + (untagged.size() > 0 ? 1 : 0)]);
        if (untagged.size() > 0) {
            this.mClusters[m] = untagged;
        }
    }

    @Override
    public int getNumberOfClusters() {
        return this.mClusters.length;
    }

    @Override
    public ArrayList<Path> getCluster(int index) {
        return this.mClusters[index].mPaths;
    }

    @Override
    public String getClusterName(int index) {
        return this.mClusters[index].mName;
    }

    @Override
    public MediaItem getClusterCover(int index) {
        return this.mClusters[index].getCover();
    }

    private class FaceCluster {
        ArrayList<Path> mPaths = new ArrayList();
        String mName;
        MediaItem mCoverItem;
        RectF mCoverRegion;
        int mCoverFaceIndex;

        public FaceCluster(String name) {
            this.mName = name;
        }

        public void add(MediaItem item, int faceIndex) {
            Path path = item.getPath();
            this.mPaths.add(path);
            Face[] faces = item.getFaces();
            if (faces != null) {
                Face face = faces[faceIndex];
                if (this.mCoverItem == null) {
                    this.mCoverItem = item;
                    this.mCoverRegion = face.getPosition();
                    this.mCoverFaceIndex = faceIndex;
                } else {
                    RectF region = face.getPosition();
                    if (this.mCoverRegion.width() < region.width() && this.mCoverRegion.height() < region.height()) {
                        this.mCoverItem = item;
                        this.mCoverRegion = face.getPosition();
                        this.mCoverFaceIndex = faceIndex;
                    }
                }
            }
        }

        public int size() {
            return this.mPaths.size();
        }

        public MediaItem getCover() {
            if (this.mCoverItem != null) {
                return this.mCoverItem;
            }
            return null;
        }
    }
}

