/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.support.v4.util.Pools;
import deviceinfo.mayur.medialibrary.data.SparseArrayBitmapPool;

public class GalleryBitmapPool {
    private static final int CAPACITY_BYTES = 0x1400000;
    private static final int POOL_INDEX_NONE = -1;
    private static final int POOL_INDEX_SQUARE = 0;
    private static final int POOL_INDEX_PHOTO = 1;
    private static final int POOL_INDEX_MISC = 2;
    private static final Point[] COMMON_PHOTO_ASPECT_RATIOS = new Point[]{new Point(4, 3), new Point(3, 2), new Point(16, 9)};
    private int mCapacityBytes;
    private SparseArrayBitmapPool[] mPools;
    private Pools.Pool<SparseArrayBitmapPool.Node> mSharedNodePool = new Pools.SynchronizedPool(128);
    private static GalleryBitmapPool sInstance = new GalleryBitmapPool(0x1400000);

    private GalleryBitmapPool(int capacityBytes) {
        this.mPools = new SparseArrayBitmapPool[3];
        this.mPools[0] = new SparseArrayBitmapPool(capacityBytes / 3, this.mSharedNodePool);
        this.mPools[1] = new SparseArrayBitmapPool(capacityBytes / 3, this.mSharedNodePool);
        this.mPools[2] = new SparseArrayBitmapPool(capacityBytes / 3, this.mSharedNodePool);
        this.mCapacityBytes = capacityBytes;
    }

    public static GalleryBitmapPool getInstance() {
        return sInstance;
    }

    private SparseArrayBitmapPool getPoolForDimensions(int width, int height) {
        int index = this.getPoolIndexForDimensions(width, height);
        if (index == -1) {
            return null;
        }
        return this.mPools[index];
    }

    private int getPoolIndexForDimensions(int width, int height) {
        int max;
        int min;
        if (width <= 0 || height <= 0) {
            return -1;
        }
        if (width == height) {
            return 0;
        }
        if (width > height) {
            min = height;
            max = width;
        } else {
            min = width;
            max = height;
        }
        for (Point ar : COMMON_PHOTO_ASPECT_RATIOS) {
            if (min * ar.x != max * ar.y) continue;
            return 1;
        }
        return 2;
    }

    public synchronized int getCapacity() {
        return this.mCapacityBytes;
    }

    public int getSize() {
        int total = 0;
        for (SparseArrayBitmapPool p : this.mPools) {
            total += p.getSize();
        }
        return total;
    }

    public Bitmap get(int width, int height) {
        SparseArrayBitmapPool pool = this.getPoolForDimensions(width, height);
        if (pool == null) {
            return null;
        }
        return pool.get(width, height);
    }

    public boolean put(Bitmap b) {
        if (b == null || b.getConfig() != Bitmap.Config.ARGB_8888) {
            return false;
        }
        SparseArrayBitmapPool pool = this.getPoolForDimensions(b.getWidth(), b.getHeight());
        if (pool == null) {
            b.recycle();
            return false;
        }
        return pool.put(b);
    }

    public void clear() {
        for (SparseArrayBitmapPool p : this.mPools) {
            p.clear();
        }
    }
}

