/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import deviceinfo.mayur.medialibrary.data.BytesBufferPool;
import deviceinfo.mayur.medialibrary.data.DecodeUtils;
import deviceinfo.mayur.medialibrary.data.ImageCacheService;
import deviceinfo.mayur.medialibrary.data.MediaDataContext;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.BitmapUtils;
import deviceinfo.mayur.medialibrary.util.ThreadPool;

abstract class ImageCacheRequest
implements ThreadPool.Job<Bitmap> {
    private static final String TAG = "ImageCacheRequest";
    protected MediaDataContext mApplication;
    private Path mPath;
    private int mType;
    private int mTargetSize;
    private long mTimeModified;

    public ImageCacheRequest(MediaDataContext application, Path path, long timeModified, int type, int targetSize) {
        this.mApplication = application;
        this.mPath = path;
        this.mType = type;
        this.mTargetSize = targetSize;
        this.mTimeModified = timeModified;
    }

    private String debugTag() {
        return this.mPath + "," + this.mTimeModified + "," + (this.mType == 1 ? "THUMB" : (this.mType == 2 ? "MICROTHUMB" : "?"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap run(ThreadPool.JobContext jc) {
        ImageCacheService cacheService = this.mApplication.getImageCacheService();
        BytesBufferPool.BytesBuffer buffer = MediaItem.getBytesBufferPool().get();
        try {
            boolean found = cacheService.getImageData(this.mPath, this.mTimeModified, this.mType, buffer);
            if (jc.isCancelled()) {
                Bitmap bitmap = null;
                return bitmap;
            }
            if (found) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inPreferredConfig = Bitmap.Config.ARGB_8888;
                Bitmap bitmap = this.mType == 2 ? DecodeUtils.decodeUsingPool(jc, buffer.data, buffer.offset, buffer.length, options) : DecodeUtils.decodeUsingPool(jc, buffer.data, buffer.offset, buffer.length, options);
                if (bitmap == null && !jc.isCancelled()) {
                    Log.w((String)TAG, (String)("decode cached failed " + this.debugTag()));
                }
                Bitmap bitmap2 = this.beforeReturningBitmap(bitmap);
                return bitmap2;
            }
        }
        finally {
            MediaItem.getBytesBufferPool().recycle(buffer);
        }
        Bitmap bitmap = this.onDecodeOriginal(jc, this.mType);
        if (jc.isCancelled()) {
            return null;
        }
        if (bitmap == null) {
            Log.w((String)TAG, (String)("decode orig failed " + this.debugTag()));
            return null;
        }
        bitmap = this.mType == 2 ? BitmapUtils.resizeAndCropCenter(bitmap, this.mTargetSize, true) : BitmapUtils.resizeDownBySideLength(bitmap, this.mTargetSize, true);
        if (jc.isCancelled()) {
            return null;
        }
        byte[] array = BitmapUtils.compressToBytes(bitmap);
        if (jc.isCancelled()) {
            return null;
        }
        cacheService.putImageData(this.mPath, this.mTimeModified, this.mType, array);
        return this.beforeReturningBitmap(bitmap);
    }

    public abstract Bitmap onDecodeOriginal(ThreadPool.JobContext var1, int var2);

    public abstract Bitmap beforeReturningBitmap(Bitmap var1);
}

