/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.content.Context;
import deviceinfo.mayur.medialibrary.data.BytesBufferPool;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.BlobCache;
import deviceinfo.mayur.medialibrary.util.CacheManager;
import deviceinfo.mayur.medialibrary.util.GalleryUtils;
import deviceinfo.mayur.medialibrary.util.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ImageCacheService {
    private static final String TAG = "ImageCacheService";
    private static final String IMAGE_CACHE_FILE = "imgcache";
    private static final int IMAGE_CACHE_MAX_ENTRIES = 5000;
    private static final int IMAGE_CACHE_MAX_BYTES = 0xC800000;
    private static final int IMAGE_CACHE_VERSION = 7;
    private BlobCache mCache;

    public ImageCacheService(Context context) {
        this.mCache = CacheManager.getCache(context, IMAGE_CACHE_FILE, 5000, 0xC800000, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getImageData(Path path, long timeModified, int type, BytesBufferPool.BytesBuffer buffer) {
        byte[] key = ImageCacheService.makeKey(path, timeModified, type);
        long cacheKey = Utils.crc64Long(key);
        try {
            BlobCache.LookupRequest request = new BlobCache.LookupRequest();
            request.key = cacheKey;
            request.buffer = buffer.data;
            BlobCache blobCache = this.mCache;
            synchronized (blobCache) {
                if (!this.mCache.lookup(request)) {
                    return false;
                }
            }
            if (ImageCacheService.isSameKey(key, request.buffer)) {
                buffer.data = request.buffer;
                buffer.offset = key.length;
                buffer.length = request.length - buffer.offset;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putImageData(Path path, long timeModified, int type, byte[] value) {
        byte[] key = ImageCacheService.makeKey(path, timeModified, type);
        long cacheKey = Utils.crc64Long(key);
        ByteBuffer buffer = ByteBuffer.allocate(key.length + value.length);
        buffer.put(key);
        buffer.put(value);
        BlobCache blobCache = this.mCache;
        synchronized (blobCache) {
            try {
                this.mCache.insert(cacheKey, buffer.array());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImageData(Path path, long timeModified, int type) {
        byte[] key = ImageCacheService.makeKey(path, timeModified, type);
        long cacheKey = Utils.crc64Long(key);
        BlobCache blobCache = this.mCache;
        synchronized (blobCache) {
            try {
                this.mCache.clearEntry(cacheKey);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static byte[] makeKey(Path path, long timeModified, int type) {
        return GalleryUtils.getBytes(path.toString() + "+" + timeModified + "+" + type);
    }

    private static boolean isSameKey(byte[] key, byte[] buffer) {
        int n = key.length;
        if (buffer.length < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (key[i] == buffer[i]) continue;
            return false;
        }
        return true;
    }
}

